/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.password.AuthECPassword;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderDAOResult;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.profile.ProfileByUUIDResponse;
import pro.gravit.utils.HookException;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public class AuthResponse
extends SimpleResponse {
    public static final transient Random random = new SecureRandom();
    public String login;
    public String client;
    public boolean getSession;
    public AuthRequest.AuthPasswordInterface password;
    public String auth_id;
    public ConnectTypes authType;

    @Override
    public String getType() {
        return "auth";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client clientData) throws Exception {
        try {
            UUID uuid;
            AuthRequestEvent result = new AuthRequestEvent();
            if (!(this.authType != null && this.authType != ConnectTypes.CLIENT || clientData != null && clientData.checkSign)) {
                AuthProvider.authError("Don't skip Launcher Update");
                return;
            }
            if (this.password instanceof AuthECPassword) {
                try {
                    this.password = new AuthPlainPassword(IOHelper.decode((byte[])SecurityHelper.decrypt((String)this.server.runtime.passwordEncryptKey, (byte[])((AuthECPassword)this.password).password)));
                }
                catch (BadPaddingException | IllegalBlockSizeException ignored) {
                    throw new AuthException("Password decryption error");
                }
            }
            if (clientData.isAuth) {
                if (LogHelper.isDevEnabled()) {
                    LogHelper.warning((String)"Client %s double auth", (Object[])new Object[]{clientData.username == null ? this.ip : clientData.username});
                }
                this.sendError("You are already logged in");
                return;
            }
            AuthProviderPair pair = this.auth_id == null || this.auth_id.isEmpty() ? this.server.config.getAuthProviderPair() : this.server.config.getAuthProviderPair(this.auth_id);
            if (pair == null) {
                this.sendError("auth_id incorrect");
                return;
            }
            AuthContext context = new AuthContext(clientData, this.login, this.client, this.ip, this.authType);
            AuthProvider provider = pair.provider;
            this.server.authHookManager.preHook.hook((Object)context, (Object)clientData);
            provider.preAuth(this.login, this.password, this.ip);
            AuthProviderResult aresult = provider.auth(this.login, this.password, this.ip);
            if (!VerifyHelper.isValidUsername((CharSequence)aresult.username)) {
                AuthProvider.authError(String.format("Illegal result: '%s'", aresult.username));
                return;
            }
            this.server.authHookManager.postHook.hook((Object)context, (Object)clientData);
            clientData.isAuth = true;
            clientData.permissions = aresult.permissions;
            clientData.auth_id = this.auth_id;
            clientData.updateAuth(this.server);
            clientData.username = aresult.username != null ? aresult.username : this.login;
            if (aresult instanceof AuthProviderDAOResult) {
                clientData.daoObject = ((AuthProviderDAOResult)aresult).daoObject;
            }
            result.accessToken = aresult.accessToken;
            result.permissions = clientData.permissions;
            if (this.getSession) {
                if (clientData.session == null) {
                    clientData.session = UUID.randomUUID();
                    this.server.sessionManager.addClient(clientData);
                }
                result.session = clientData.session;
            }
            if (this.authType == ConnectTypes.CLIENT && this.server.config.protectHandler.allowGetAccessToken(context)) {
                uuid = pair.handler.auth(aresult);
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.debug((String)"Auth: %s accessToken %s uuid: %s", (Object[])new Object[]{this.login, result.accessToken, uuid.toString()});
                }
            } else {
                uuid = pair.handler.usernameToUUID(aresult.username);
                result.accessToken = null;
            }
            result.playerProfile = ProfileByUUIDResponse.getProfile(uuid, aresult.username, this.client, clientData.auth.textureProvider);
            clientData.type = this.authType;
            this.sendResult((RequestEvent)result);
        }
        catch (AuthException | HookException e) {
            this.sendError(e.getMessage());
        }
    }

    public static class AuthContext {
        public final String login;
        public final String profileName;
        public final String ip;
        public final ConnectTypes authType;
        public final Client client;
        @Deprecated
        public int password_length;

        public AuthContext(Client client, String login, String profileName, String ip, ConnectTypes authType) {
            this.client = client;
            this.login = login;
            this.profileName = profileName;
            this.ip = ip;
            this.authType = authType;
        }
    }

    public static enum ConnectTypes {
        SERVER,
        CLIENT,
        API;

    }
}

