/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.auth.protect.interfaces.ProfilesProtectHandler;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;

public class ProfilesResponse
extends SimpleResponse {
    @Override
    public String getType() {
        return "profiles";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        List<ClientProfile> profileList;
        if (this.server.config.protectHandler instanceof ProfilesProtectHandler && !((ProfilesProtectHandler)((Object)this.server.config.protectHandler)).canGetProfiles(client)) {
            this.sendError("Access denied");
            return;
        }
        List<ClientProfile> serverProfiles = this.server.getProfiles();
        if (this.server.config.protectHandler instanceof ProfilesProtectHandler) {
            ProfilesProtectHandler protectHandler = (ProfilesProtectHandler)((Object)this.server.config.protectHandler);
            profileList = new ArrayList<ClientProfile>(4);
            for (ClientProfile profile : serverProfiles) {
                if (!protectHandler.canGetProfile(profile, client)) continue;
                profileList.add(profile);
            }
        } else {
            profileList = serverProfiles;
        }
        this.sendResult((RequestEvent)new ProfilesRequestEvent(profileList));
    }
}

