/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.update;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.Base64;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherResponse
extends SimpleResponse {
    public Version version;
    public String hash;
    public byte[] digest;
    public int launcher_type;
    public String secureHash;
    public String secureSalt;

    @Override
    public String getType() {
        return "launcher";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        byte[] bytes = this.hash != null ? Base64.getDecoder().decode(this.hash) : this.digest;
        if (this.launcher_type == 1) {
            byte[] hash = this.server.launcherBinary.getDigest();
            if (hash == null) {
                this.service.sendObjectAndClose(ctx, new LauncherRequestEvent(true, this.server.config.netty.launcherURL));
            }
            if (Arrays.equals(bytes, hash) && this.checkSecure(this.secureHash, this.secureSalt)) {
                client.checkSign = true;
                this.sendResult((RequestEvent)new LauncherRequestEvent(false, this.server.config.netty.launcherURL));
            } else {
                this.sendResultAndClose((RequestEvent)new LauncherRequestEvent(true, this.server.config.netty.launcherURL));
            }
        } else if (this.launcher_type == 2) {
            byte[] hash = this.server.launcherEXEBinary.getDigest();
            if (hash == null) {
                this.sendResultAndClose((RequestEvent)new LauncherRequestEvent(true, this.server.config.netty.launcherEXEURL));
            }
            if (Arrays.equals(bytes, hash) && this.checkSecure(this.secureHash, this.secureSalt)) {
                client.checkSign = true;
                this.sendResult((RequestEvent)new LauncherRequestEvent(false, this.server.config.netty.launcherEXEURL));
            } else {
                this.sendResultAndClose((RequestEvent)new LauncherRequestEvent(true, this.server.config.netty.launcherEXEURL));
            }
        } else {
            this.sendError("Request launcher type error");
        }
    }

    private boolean checkSecure(String hash, String salt) {
        if (hash == null || salt == null) {
            return false;
        }
        byte[] normal_hash = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA256, (String)this.server.runtime.clientCheckSecret.concat(".").concat(salt));
        byte[] launcher_hash = Base64.getDecoder().decode(hash);
        return Arrays.equals(normal_hash, launcher_hash);
    }
}

