/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.update;

import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.UpdateRequestEvent;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launchserver.auth.protect.interfaces.ProfilesProtectHandler;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.utils.helper.IOHelper;

public class UpdateResponse
extends SimpleResponse {
    public String dirName;

    @Override
    public String getType() {
        return "update";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        if (this.server.config.protectHandler instanceof ProfilesProtectHandler && !((ProfilesProtectHandler)((Object)this.server.config.protectHandler)).canGetUpdates(this.dirName, client)) {
            this.sendError("Access denied");
            return;
        }
        if (this.dirName == null) {
            this.sendError("Invalid request");
            return;
        }
        HashedDir dir = this.server.updatesDirMap.get(this.dirName);
        if (dir == null) {
            this.sendError(String.format("Directory %s not found", this.dirName));
            return;
        }
        String url = this.server.config.netty.downloadURL.replace("%dirname%", IOHelper.urlEncode((String)this.dirName));
        boolean zip = false;
        if (this.server.config.netty.bindings.get(this.dirName) != null) {
            LaunchServerConfig.NettyUpdatesBind bind = this.server.config.netty.bindings.get(this.dirName);
            url = bind.url;
            zip = bind.zip;
        }
        this.sendResult((RequestEvent)new UpdateRequestEvent(dir, url, zip));
    }
}

