/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.NeedGarbageCollection;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.managers.ConfigManager;
import pro.gravit.launcher.managers.GarbageManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.events.ClosePhase;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.session.MemorySessionStorage;
import pro.gravit.launchserver.binary.EXEL4JLauncherBinary;
import pro.gravit.launchserver.binary.EXELauncherBinary;
import pro.gravit.launchserver.binary.JARLauncherBinary;
import pro.gravit.launchserver.binary.LauncherBinary;
import pro.gravit.launchserver.binary.ProguardConf;
import pro.gravit.launchserver.command.handler.CommandHandler;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.config.LaunchServerRuntimeConfig;
import pro.gravit.launchserver.launchermodules.LauncherModuleLoader;
import pro.gravit.launchserver.manangers.CertificateManager;
import pro.gravit.launchserver.manangers.FeaturesManager;
import pro.gravit.launchserver.manangers.MirrorManager;
import pro.gravit.launchserver.manangers.PingServerManager;
import pro.gravit.launchserver.manangers.ReconfigurableManager;
import pro.gravit.launchserver.manangers.SessionManager;
import pro.gravit.launchserver.manangers.hook.AuthHookManager;
import pro.gravit.launchserver.modules.events.LaunchServerFullInitEvent;
import pro.gravit.launchserver.modules.events.LaunchServerInitPhase;
import pro.gravit.launchserver.modules.events.LaunchServerPostInitPhase;
import pro.gravit.launchserver.modules.events.NewLaunchServerInstanceEvent;
import pro.gravit.launchserver.modules.impl.LaunchServerModulesManager;
import pro.gravit.launchserver.socket.handlers.NettyServerSocketHandler;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public final class LaunchServer
implements Runnable,
AutoCloseable,
Reconfigurable {
    public static final Class<? extends LauncherBinary> defaultLauncherEXEBinaryClass = null;
    public final Path dir;
    public final LaunchServerEnv env;
    public final Path launcherLibraries;
    public final Path launcherLibrariesCompile;
    public final Path caCertFile;
    public final Path caKeyFile;
    public final Path serverCertFile;
    public final Path serverKeyFile;
    public final Path updatesDir;
    public final LaunchServerConfigManager launchServerConfigManager;
    public final Path profilesDir;
    public final LaunchServerRuntimeConfig runtime;
    public final ECPublicKey publicKey;
    public final ECPrivateKey privateKey;
    public final JARLauncherBinary launcherBinary;
    public final Class<? extends LauncherBinary> launcherEXEBinaryClass;
    public final LauncherBinary launcherEXEBinary;
    public final SessionManager sessionManager;
    public final AuthHookManager authHookManager;
    public final LaunchServerModulesManager modulesManager;
    public final MirrorManager mirrorManager;
    public final ReconfigurableManager reconfigurableManager;
    public final ConfigManager configManager;
    public final PingServerManager pingServerManager;
    public final FeaturesManager featuresManager;
    public final CertificateManager certificateManager;
    public final ProguardConf proguardConf;
    public final pro.gravit.utils.command.CommandHandler commandHandler;
    public final NettyServerSocketHandler nettyServerSocketHandler;
    public final Timer taskPool;
    public final AtomicBoolean started = new AtomicBoolean(false);
    public final LauncherModuleLoader launcherModuleLoader;
    public LaunchServerConfig config;
    public volatile Map<String, HashedDir> updatesDirMap;
    private volatile List<ClientProfile> profilesList;

    public LaunchServer(LaunchServerDirectories directories, LaunchServerEnv env, LaunchServerConfig config, LaunchServerRuntimeConfig runtimeConfig, LaunchServerConfigManager launchServerConfigManager, LaunchServerModulesManager modulesManager, ECPublicKey publicKey, ECPrivateKey privateKey, pro.gravit.utils.command.CommandHandler commandHandler, CertificateManager certificateManager) throws IOException {
        this.dir = directories.dir;
        this.env = env;
        this.config = config;
        this.launchServerConfigManager = launchServerConfigManager;
        this.modulesManager = modulesManager;
        this.profilesDir = directories.profilesDir;
        this.updatesDir = directories.updatesDir;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.commandHandler = commandHandler;
        this.runtime = runtimeConfig;
        this.certificateManager = certificateManager;
        this.taskPool = new Timer("Timered task worker thread", true);
        this.launcherLibraries = directories.launcherLibrariesDir;
        this.launcherLibrariesCompile = directories.launcherLibrariesCompileDir;
        config.setLaunchServer(this);
        this.caCertFile = this.dir.resolve("ca.crt");
        this.caKeyFile = this.dir.resolve("ca.key");
        this.serverCertFile = this.dir.resolve("server.crt");
        this.serverKeyFile = this.dir.resolve("server.key");
        modulesManager.invokeEvent(new NewLaunchServerInstanceEvent(this));
        this.launcherEXEBinaryClass = defaultLauncherEXEBinaryClass;
        this.runtime.verify();
        config.verify();
        if (config.sessions == null) {
            config.sessions = new MemorySessionStorage();
        }
        if (config.components != null) {
            LogHelper.debug((String)"PreInit components");
            config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"PreInit component %s", (Object[])new Object[]{k});
                v.preInit(this);
            });
            LogHelper.debug((String)"PreInit components successful");
        }
        this.proguardConf = new ProguardConf(this);
        this.sessionManager = new SessionManager(this);
        this.mirrorManager = new MirrorManager();
        this.reconfigurableManager = new ReconfigurableManager();
        this.authHookManager = new AuthHookManager();
        this.configManager = new ConfigManager();
        this.pingServerManager = new PingServerManager(this);
        this.featuresManager = new FeaturesManager(this);
        certificateManager.orgName = config.projectName;
        config.init(ReloadType.FULL);
        this.registerObject("launchServer", this);
        GarbageManager.registerNeedGC((NeedGarbageCollection)this.sessionManager);
        CommandHandler.registerCommands(commandHandler, this);
        modulesManager.invokeEvent((LauncherModule.Event)new LaunchServerInitPhase(this));
        if (config.components != null) {
            LogHelper.debug((String)"Init components");
            config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"Init component %s", (Object[])new Object[]{k});
                v.init(this);
            });
            LogHelper.debug((String)"Init components successful");
        }
        this.launcherBinary = new JARLauncherBinary(this);
        this.launcherEXEBinary = this.binary();
        this.launcherBinary.init();
        this.launcherEXEBinary.init();
        this.syncLauncherBinaries();
        this.launcherModuleLoader = new LauncherModuleLoader(this);
        if (!IOHelper.isDir((Path)this.updatesDir)) {
            Files.createDirectory(this.updatesDir, new FileAttribute[0]);
        }
        this.syncUpdatesDir(null);
        if (!IOHelper.isDir((Path)this.profilesDir)) {
            Files.createDirectory(this.profilesDir, new FileAttribute[0]);
        }
        this.syncProfilesDir();
        this.launcherModuleLoader.init();
        this.nettyServerSocketHandler = new NettyServerSocketHandler(this);
        modulesManager.invokeEvent((LauncherModule.Event)new LaunchServerPostInitPhase(this));
        if (config.components != null) {
            LogHelper.debug((String)"PostInit components");
            config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"PostInit component %s", (Object[])new Object[]{k});
                v.postInit(this);
            });
            LogHelper.debug((String)"PostInit components successful");
        }
    }

    public void reload(ReloadType type) throws Exception {
        this.config.close(type);
        Map<String, AuthProviderPair> pairs = null;
        if (type.equals((Object)ReloadType.NO_AUTH)) {
            pairs = this.config.auth;
        }
        LogHelper.info((String)"Reading LaunchServer config file");
        this.config = this.launchServerConfigManager.readConfig();
        this.config.setLaunchServer(this);
        if (type.equals((Object)ReloadType.NO_AUTH)) {
            this.config.auth = pairs;
        }
        this.config.verify();
        this.config.init(type);
        if (type.equals((Object)ReloadType.FULL) && this.config.components != null) {
            LogHelper.debug((String)"PreInit components");
            this.config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"PreInit component %s", (Object[])new Object[]{k});
                v.preInit(this);
            });
            LogHelper.debug((String)"PreInit components successful");
            LogHelper.debug((String)"Init components");
            this.config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"Init component %s", (Object[])new Object[]{k});
                v.init(this);
            });
            LogHelper.debug((String)"Init components successful");
            LogHelper.debug((String)"PostInit components");
            this.config.components.forEach((k, v) -> {
                LogHelper.subDebug((String)"PostInit component %s", (Object[])new Object[]{k});
                v.postInit(this);
            });
            LogHelper.debug((String)"PostInit components successful");
        }
    }

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        SubCommand reload = new SubCommand(){

            public void invoke(String ... args) throws Exception {
                if (args.length == 0) {
                    LaunchServer.this.reload(ReloadType.FULL);
                    return;
                }
                switch (args[0]) {
                    case "full": {
                        LaunchServer.this.reload(ReloadType.FULL);
                        break;
                    }
                    case "no_auth": {
                        LaunchServer.this.reload(ReloadType.NO_AUTH);
                        break;
                    }
                    case "no_components": {
                        LaunchServer.this.reload(ReloadType.NO_COMPONENTS);
                        break;
                    }
                    default: {
                        LaunchServer.this.reload(ReloadType.FULL);
                    }
                }
            }
        };
        commands.put("reload", (Command)reload);
        return commands;
    }

    private LauncherBinary binary() {
        if (this.launcherEXEBinaryClass != null) {
            try {
                return MethodHandles.publicLookup().findConstructor(this.launcherEXEBinaryClass, MethodType.methodType(Void.TYPE, LaunchServer.class)).invoke(this);
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
            }
        }
        try {
            Class.forName("net.sf.launch4j.Builder");
            if (this.config.launch4j.enabled) {
                return new EXEL4JLauncherBinary(this);
            }
        }
        catch (ClassNotFoundException ignored) {
            LogHelper.warning((String)"Launch4J isn't in classpath.");
        }
        return new EXELauncherBinary(this);
    }

    public void buildLauncherBinaries() throws IOException {
        this.launcherBinary.build();
        this.launcherEXEBinary.build();
    }

    @Override
    public void close() throws Exception {
        this.config.close(ReloadType.FULL);
        this.modulesManager.invokeEvent((LauncherModule.Event)new ClosePhase());
        LogHelper.info((String)"Save LaunchServer runtime config");
        this.launchServerConfigManager.writeRuntimeConfig(this.runtime);
        LogHelper.info((String)"LaunchServer stopped");
    }

    public List<ClientProfile> getProfiles() {
        return this.profilesList;
    }

    public void setProfiles(List<ClientProfile> profilesList) {
        this.profilesList = Collections.unmodifiableList(profilesList);
    }

    public HashedDir getUpdateDir(String name) {
        return this.updatesDirMap.get(name);
    }

    public Set<Map.Entry<String, HashedDir>> getUpdateDirs() {
        return this.updatesDirMap.entrySet();
    }

    public void rebindNettyServerSocket() {
        this.nettyServerSocketHandler.close();
        CommonHelper.newThread((String)"Netty Server Socket Thread", (boolean)false, (Runnable)this.nettyServerSocketHandler).start();
    }

    @Override
    public void run() {
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("LaunchServer has been already started");
        }
        if (!this.env.equals((Object)LaunchServerEnv.TEST)) {
            JVMHelper.RUNTIME.addShutdownHook(CommonHelper.newThread(null, (boolean)false, () -> {
                try {
                    this.close();
                }
                catch (Exception e) {
                    LogHelper.error((Throwable)e);
                }
            }));
            CommonHelper.newThread((String)"Command Thread", (boolean)true, (Runnable)this.commandHandler).start();
        }
        if (this.config.netty != null) {
            this.rebindNettyServerSocket();
        }
        this.modulesManager.fullInitializedLaunchServer(this);
        this.modulesManager.invokeEvent(new LaunchServerFullInitEvent(this));
    }

    public void syncLauncherBinaries() throws IOException {
        LogHelper.info((String)"Syncing launcher binaries");
        LogHelper.info((String)"Syncing launcher binary file");
        if (!this.launcherBinary.sync()) {
            LogHelper.warning((String)"Missing launcher binary file");
        }
        LogHelper.info((String)"Syncing launcher EXE binary file");
        if (!this.launcherEXEBinary.sync() && this.config.launch4j.enabled) {
            LogHelper.warning((String)"Missing launcher EXE binary file");
        }
    }

    public void syncProfilesDir() throws IOException {
        LogHelper.info((String)"Syncing profiles dir");
        LinkedList<ClientProfile> newProfies = new LinkedList<ClientProfile>();
        IOHelper.walk((Path)this.profilesDir, (FileVisitor)new ProfilesFileVisitor(newProfies), (boolean)false);
        newProfies.sort(Comparator.comparing(a -> a));
        this.profilesList = Collections.unmodifiableList(newProfies);
        if (this.pingServerManager != null) {
            this.pingServerManager.syncServers();
        }
    }

    public void syncUpdatesDir(Collection<String> dirs) throws IOException {
        LogHelper.info((String)"Syncing updates dir");
        HashMap<String, HashedDir> newUpdatesDirMap = new HashMap<String, HashedDir>(16);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.updatesDir);){
            for (Path updateDir : dirStream) {
                HashedDir hdir;
                if (Files.isHidden(updateDir)) continue;
                String name = IOHelper.getFileName((Path)updateDir);
                if (!IOHelper.isDir((Path)updateDir)) {
                    if (IOHelper.isFile((Path)updateDir) || !Stream.of(".jar", ".exe", ".hash").noneMatch(e -> updateDir.toString().endsWith((String)e))) continue;
                    LogHelper.warning((String)"Not update dir: '%s'", (Object[])new Object[]{name});
                    continue;
                }
                if (dirs != null && !dirs.contains(name) && (hdir = this.updatesDirMap.get(name)) != null) {
                    newUpdatesDirMap.put(name, hdir);
                    continue;
                }
                LogHelper.info((String)"Syncing '%s' update dir", (Object[])new Object[]{name});
                HashedDir updateHDir = new HashedDir(updateDir, null, true, true);
                newUpdatesDirMap.put(name, updateHDir);
            }
        }
        this.updatesDirMap = Collections.unmodifiableMap(newUpdatesDirMap);
    }

    public void restart() {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (this.config.startScript == null) {
            throw new IllegalArgumentException("Please create start script and link it as startScript in config.");
        }
        builder.command(Collections.singletonList(this.config.startScript));
        builder.directory(this.dir.toFile());
        builder.inheritIO();
        builder.redirectErrorStream(true);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        try {
            builder.start();
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
    }

    public void registerObject(String name, Object object) {
        if (object instanceof Reconfigurable) {
            this.reconfigurableManager.registerReconfigurable(name, (Reconfigurable)object);
        }
        if (object instanceof NeedGarbageCollection) {
            GarbageManager.registerNeedGC((NeedGarbageCollection)((NeedGarbageCollection)object));
        }
    }

    public void unregisterObject(String name, Object object) {
        if (object instanceof Reconfigurable) {
            this.reconfigurableManager.unregisterReconfigurable(name);
        }
        if (object instanceof NeedGarbageCollection) {
            GarbageManager.unregisterNeedGC((NeedGarbageCollection)((NeedGarbageCollection)object));
        }
    }

    public void fullyRestart() {
        this.restart();
        JVMHelper.RUNTIME.exit(0);
    }

    public static class LaunchServerDirectories {
        public static final String UPDATES_NAME = "updates";
        public static final String PROFILES_NAME = "profiles";
        public static final String TRUSTSTORE_NAME = "truststore";
        public static final String LAUNCHERLIBRARIES_NAME = "launcher-libraries";
        public static final String LAUNCHERLIBRARIESCOMPILE_NAME = "launcher-libraries-compile";
        public Path updatesDir;
        public Path profilesDir;
        public Path launcherLibrariesDir;
        public Path launcherLibrariesCompileDir;
        public Path dir;
        public Path trustStore;

        public void collect() {
            if (this.updatesDir == null) {
                this.updatesDir = this.dir.resolve(UPDATES_NAME);
            }
            if (this.profilesDir == null) {
                this.profilesDir = this.dir.resolve(PROFILES_NAME);
            }
            if (this.trustStore == null) {
                this.trustStore = this.dir.resolve(TRUSTSTORE_NAME);
            }
            if (this.launcherLibrariesDir == null) {
                this.launcherLibrariesDir = this.dir.resolve(LAUNCHERLIBRARIES_NAME);
            }
            if (this.launcherLibrariesCompileDir == null) {
                this.launcherLibrariesCompileDir = this.dir.resolve(LAUNCHERLIBRARIESCOMPILE_NAME);
            }
        }
    }

    private static final class ProfilesFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Collection<ClientProfile> result;

        private ProfilesFileVisitor(Collection<ClientProfile> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            ClientProfile profile;
            LogHelper.info((String)"Syncing '%s' profile", (Object[])new Object[]{IOHelper.getFileName((Path)file)});
            try (BufferedReader reader = IOHelper.newReader((Path)file);){
                profile = (ClientProfile)Launcher.gsonManager.gson.fromJson((Reader)reader, ClientProfile.class);
            }
            profile.verify();
            this.result.add(profile);
            return super.visitFile(file, attrs);
        }
    }

    public static interface LaunchServerConfigManager {
        public LaunchServerConfig readConfig() throws IOException;

        public LaunchServerRuntimeConfig readRuntimeConfig() throws IOException;

        public void writeConfig(LaunchServerConfig var1) throws IOException;

        public void writeRuntimeConfig(LaunchServerRuntimeConfig var1) throws IOException;
    }

    public static enum LaunchServerEnv {
        TEST,
        DEV,
        DEBUG,
        PRODUCTION;

    }

    public static enum ReloadType {
        NO_AUTH,
        NO_COMPONENTS,
        FULL;

    }
}

