/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.handler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.NeedGarbageCollection;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.handler.AuthHandler;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public abstract class CachedAuthHandler
extends AuthHandler
implements NeedGarbageCollection,
Reconfigurable {
    private final transient Map<UUID, Entry> entryCache = new HashMap<UUID, Entry>(1024);
    private final transient Map<String, UUID> usernamesCache = new HashMap<String, UUID>(1024);

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("clear", (Command)new SubCommand(){

            public void invoke(String ... args) {
                long entryCacheSize = CachedAuthHandler.this.entryCache.size();
                long usernamesCacheSize = CachedAuthHandler.this.usernamesCache.size();
                CachedAuthHandler.this.entryCache.clear();
                CachedAuthHandler.this.usernamesCache.clear();
                LogHelper.info((String)"Cleared cache: %d Entry %d Usernames", (Object[])new Object[]{entryCacheSize, usernamesCacheSize});
            }
        });
        commands.put("load", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                int size_username;
                int size_entry;
                this.verifyArgs(args, 2);
                LogHelper.info((String)"CachedAuthHandler read from %s", (Object[])new Object[]{args[0]});
                try (BufferedReader reader = IOHelper.newReader((Path)Paths.get(args[1], new String[0]));){
                    EntryAndUsername entryAndUsername = (EntryAndUsername)Launcher.gsonManager.configGson.fromJson((Reader)reader, EntryAndUsername.class);
                    size_entry = entryAndUsername.entryCache.size();
                    size_username = entryAndUsername.usernameCache.size();
                    CachedAuthHandler.this.loadEntryCache(entryAndUsername.entryCache);
                    CachedAuthHandler.this.loadUsernameCache(entryAndUsername.usernameCache);
                }
                LogHelper.subInfo((String)"Readed %d entryCache %d usernameCache", (Object[])new Object[]{size_entry, size_username});
            }
        });
        commands.put("unload", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 2);
                LogHelper.info((String)"CachedAuthHandler write to %s", (Object[])new Object[]{args[1]});
                Map<UUID, Entry> entryCache = CachedAuthHandler.this.getEntryCache();
                Map<String, UUID> usernamesCache = CachedAuthHandler.this.getUsernamesCache();
                EntryAndUsername serializable = new EntryAndUsername();
                serializable.entryCache = entryCache;
                serializable.usernameCache = usernamesCache;
                try (BufferedWriter writer = IOHelper.newWriter((Path)Paths.get(args[1], new String[0]));){
                    Launcher.gsonManager.configGson.toJson((Object)serializable, (Appendable)writer);
                }
                LogHelper.subInfo((String)"Write %d entryCache, %d usernameCache", (Object[])new Object[]{entryCache.size(), usernamesCache.size()});
            }
        });
        return commands;
    }

    protected void addEntry(Entry entry) {
        Entry previous = this.entryCache.put(entry.uuid, entry);
        if (previous != null) {
            this.usernamesCache.remove(CommonHelper.low((String)previous.username));
        }
        this.usernamesCache.put(CommonHelper.low((String)entry.username), entry.uuid);
    }

    @Override
    public final synchronized UUID auth(AuthProviderResult result) throws IOException {
        Entry entry = this.getEntry(result.username);
        if (entry == null || !this.updateAuth(entry.uuid, entry.username, result.accessToken)) {
            return CachedAuthHandler.authError(String.format("UUID is null for username '%s'", result.username));
        }
        entry.username = result.username;
        entry.accessToken = result.accessToken;
        entry.serverID = null;
        return entry.uuid;
    }

    @Override
    public synchronized UUID checkServer(String username, String serverID) throws IOException {
        Entry entry = this.getEntry(username);
        return entry != null && username.equals(entry.username) && serverID.equals(entry.serverID) ? entry.uuid : null;
    }

    protected abstract Entry fetchEntry(String var1) throws IOException;

    protected abstract Entry fetchEntry(UUID var1) throws IOException;

    private Entry getEntry(String username) throws IOException {
        UUID uuid = this.usernamesCache.get(CommonHelper.low((String)username));
        if (uuid != null) {
            return this.getEntry(uuid);
        }
        Entry entry = this.fetchEntry(username);
        if (entry != null) {
            this.addEntry(entry);
        }
        return entry;
    }

    private Entry getEntry(UUID uuid) throws IOException {
        Entry entry = this.entryCache.get(uuid);
        if (entry == null && (entry = this.fetchEntry(uuid)) != null) {
            this.addEntry(entry);
        }
        return entry;
    }

    @Override
    public synchronized boolean joinServer(String username, String accessToken, String serverID) throws IOException {
        Entry entry = this.getEntry(username);
        if (!(entry != null && username.equals(entry.username) && accessToken.equals(entry.accessToken) && this.updateServerID(entry.uuid, serverID))) {
            return false;
        }
        entry.serverID = serverID;
        return true;
    }

    public synchronized void garbageCollection() {
        this.entryCache.clear();
        this.usernamesCache.clear();
    }

    public Map<UUID, Entry> getEntryCache() {
        return this.entryCache;
    }

    public Map<String, UUID> getUsernamesCache() {
        return this.usernamesCache;
    }

    public void loadEntryCache(Map<UUID, Entry> map) {
        this.entryCache.putAll(map);
    }

    public void loadUsernameCache(Map<String, UUID> map) {
        this.usernamesCache.putAll(map);
    }

    protected abstract boolean updateAuth(UUID var1, String var2, String var3) throws IOException;

    protected abstract boolean updateServerID(UUID var1, String var2) throws IOException;

    @Override
    public final synchronized UUID usernameToUUID(String username) throws IOException {
        Entry entry = this.getEntry(username);
        return entry == null ? null : entry.uuid;
    }

    @Override
    public final synchronized String uuidToUsername(UUID uuid) throws IOException {
        Entry entry = this.getEntry(uuid);
        return entry == null ? null : entry.username;
    }

    protected static class EntryAndUsername {
        public Map<UUID, Entry> entryCache;
        public Map<String, UUID> usernameCache;

        protected EntryAndUsername() {
        }
    }

    public static final class Entry {
        public final UUID uuid;
        private String username;
        private String accessToken;
        private String serverID;

        public Entry(UUID uuid, String username, String accessToken, String serverID) {
            this.uuid = Objects.requireNonNull(uuid, "uuid");
            this.username = Objects.requireNonNull(username, "username");
            this.accessToken = accessToken == null ? null : SecurityHelper.verifyToken((String)accessToken);
            this.serverID = serverID == null ? null : VerifyHelper.verifyServerID((String)serverID);
        }
    }
}

