/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.asm.ClassMetadataReader;
import pro.gravit.launchserver.asm.InjectClassAcceptor;
import pro.gravit.launchserver.asm.SafeClassWriter;
import pro.gravit.launchserver.binary.BuildContext;
import pro.gravit.launchserver.binary.tasks.CertificateAutogenTask;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.HookException;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class MainBuildTask
implements LauncherBuildTask {
    public final ClassMetadataReader reader;
    private final LaunchServer server;
    public final Set<String> blacklist = new HashSet<String>();
    public final List<Transformer> transformers = new ArrayList<Transformer>();
    public final IOHookSet<BuildContext> preBuildHook = new IOHookSet();
    public final IOHookSet<BuildContext> postBuildHook = new IOHookSet();
    public final Map<String, Object> properties = new HashMap<String, Object>();

    public MainBuildTask(LaunchServer srv) {
        this.server = srv;
        this.reader = new ClassMetadataReader();
        InjectClassAcceptor injectClassAcceptor = new InjectClassAcceptor(this.properties);
        this.transformers.add(injectClassAcceptor);
    }

    @Override
    public String getName() {
        return "MainBuild";
    }

    @Override
    public Path process(Path inputJar) throws IOException {
        Path outputJar = this.server.launcherBinary.nextPath("main");
        try (ZipOutputStream output = new ZipOutputStream(IOHelper.newOutput((Path)outputJar));){
            BuildContext context = new BuildContext(output, this.reader.getCp(), this);
            this.initProps();
            this.preBuildHook.hook(context);
            this.properties.put("launcher.modules", context.clientModules.stream().map(e -> Type.getObjectType((String)e.replace('.', '/'))).collect(Collectors.toList()));
            this.postInitProps();
            this.reader.getCp().add(new JarFile(inputJar.toFile()));
            this.server.launcherBinary.coreLibs.forEach(e -> {
                try {
                    this.reader.getCp().add(new JarFile(e.toFile()));
                }
                catch (IOException e1) {
                    LogHelper.error((Throwable)e1);
                }
            });
            context.pushJarFile(inputJar, e -> this.blacklist.contains(e.getName()), e -> true);
            HashMap<String, byte[]> runtime = new HashMap<String, byte[]>(256);
            context.pushDir(this.server.launcherBinary.runtimeDir, "runtime", runtime, false);
            context.pushDir(this.server.launcherBinary.guardDir, "guard", runtime, false);
            LauncherConfig launcherConfig = new LauncherConfig(this.server.config.netty.address, this.server.publicKey, runtime, this.server.config.projectName);
            context.pushFile("config.bin", (StreamObject)launcherConfig);
            this.postBuildHook.hook(context);
        }
        this.reader.close();
        return outputJar;
    }

    protected void postInitProps() {
        List certificates = Arrays.stream(this.server.certificateManager.trustManager.getTrusted()).map(e -> {
            try {
                return e.getEncoded();
            }
            catch (CertificateEncodingException e2) {
                LogHelper.error((Throwable)e2);
                return new byte[0];
            }
        }).collect(Collectors.toList());
        if (!this.server.config.sign.enabled) {
            CertificateAutogenTask task = this.server.launcherBinary.getTaskByClass(CertificateAutogenTask.class).get();
            try {
                certificates.add(task.certificate.getEncoded());
            }
            catch (CertificateEncodingException e2) {
                throw new InternalError(e2);
            }
        }
        this.properties.put("launchercore.certificates", certificates);
    }

    protected void initProps() {
        this.properties.clear();
        this.properties.put("launcher.address", this.server.config.netty.address);
        this.properties.put("launcher.projectName", this.server.config.projectName);
        this.properties.put("runtimeconfig.secretKeyClient", SecurityHelper.randomStringAESKey());
        this.properties.put("launcher.port", 32148 + SecurityHelper.newRandom().nextInt(512));
        this.properties.put("launcher.guardType", this.server.config.launcher.guardType);
        this.properties.put("launcher.isWarningMissArchJava", this.server.config.launcher.warningMissArchJava);
        this.properties.put("launchercore.env", this.server.config.env);
        this.properties.put("runtimeconfig.passwordEncryptKey", this.server.runtime.passwordEncryptKey);
        String launcherSalt = SecurityHelper.randomStringToken();
        byte[] launcherSecureHash = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA256, (String)this.server.runtime.clientCheckSecret.concat(".").concat(launcherSalt));
        this.properties.put("runtimeconfig.secureCheckHash", Base64.getEncoder().encodeToString(launcherSecureHash));
        this.properties.put("runtimeconfig.secureCheckSalt", launcherSalt);
        if (this.server.runtime.oemUnlockKey == null) {
            this.server.runtime.oemUnlockKey = SecurityHelper.randomStringToken();
        }
        this.properties.put("runtimeconfig.oemUnlockKey", this.server.runtime.oemUnlockKey);
    }

    public byte[] transformClass(byte[] bytes, String classname, BuildContext context) {
        SafeClassWriter writer;
        byte[] result = bytes;
        ClassNode cn = null;
        for (Transformer t : this.transformers) {
            byte[] old_result;
            if (t instanceof ASMTransformer) {
                ASMTransformer asmTransformer = (ASMTransformer)t;
                if (cn == null) {
                    ClassReader cr = new ClassReader(result);
                    cn = new ClassNode();
                    cr.accept((ClassVisitor)cn, 0);
                }
                asmTransformer.transform(cn, classname, context);
                continue;
            }
            if (cn != null) {
                writer = new SafeClassWriter(this.reader, 3);
                cn.accept((ClassVisitor)writer);
                result = writer.toByteArray();
            }
            if ((old_result = result) == (result = t.transform(result, classname, context))) continue;
            cn = null;
        }
        if (cn != null) {
            writer = new SafeClassWriter(this.reader, 3);
            cn.accept((ClassVisitor)writer);
            result = writer.toByteArray();
        }
        return result;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    public static abstract class ASMAnnotationFieldProcessor
    implements ASMTransformer {
        private final String desc;

        protected ASMAnnotationFieldProcessor(String desc) {
            this.desc = desc;
        }

        @Override
        public void transform(ClassNode cn, String classname, BuildContext context) {
            for (FieldNode fn : cn.fields) {
                if (fn.invisibleAnnotations == null || fn.invisibleAnnotations.isEmpty()) continue;
                AnnotationNode found = null;
                for (AnnotationNode an : fn.invisibleAnnotations) {
                    if (an == null || !this.desc.equals(an.desc)) continue;
                    found = an;
                    break;
                }
                if (found == null) continue;
                this.transformField(found, fn, cn, classname, context);
            }
        }

        public abstract void transformField(AnnotationNode var1, FieldNode var2, ClassNode var3, String var4, BuildContext var5);
    }

    public static class IOHookSet<R> {
        public final Set<IOHook<R>> list = new HashSet<IOHook<R>>();

        public void registerHook(IOHook<R> hook) {
            this.list.add(hook);
        }

        public boolean unregisterHook(IOHook<R> hook) {
            return this.list.remove(hook);
        }

        public void hook(R context) throws HookException, IOException {
            for (IOHook<R> hook : this.list) {
                hook.hook(context);
            }
        }

        @FunctionalInterface
        public static interface IOHook<R> {
            public void hook(R var1) throws HookException, IOException;
        }
    }

    public static interface ASMTransformer
    extends Transformer {
        @Override
        default public byte[] transform(byte[] input, String classname, BuildContext context) {
            ClassReader reader = new ClassReader(input);
            ClassNode cn = new ClassNode();
            reader.accept((ClassVisitor)cn, 0);
            this.transform(cn, classname, context);
            SafeClassWriter writer = new SafeClassWriter(context.task.reader, 3);
            cn.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }

        public void transform(ClassNode var1, String var2, BuildContext var3);
    }

    @FunctionalInterface
    public static interface Transformer {
        public byte[] transform(byte[] var1, String var2, BuildContext var3);
    }
}

