/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import java.net.SocketAddress;
import java.util.Base64;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.WebSocketService;
import pro.gravit.launchserver.socket.handlers.WebSocketFrameHandler;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class ClientsCommand
extends Command {
    public ClientsCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return null;
    }

    public String getUsageDescription() {
        return "Show all connected clients";
    }

    public void invoke(String ... args) {
        WebSocketService service = this.server.nettyServerSocketHandler.nettyServer.service;
        service.channels.forEach(channel -> {
            String ip;
            WebSocketFrameHandler frameHandler = (WebSocketFrameHandler)channel.pipeline().get(WebSocketFrameHandler.class);
            Client client = frameHandler.getClient();
            String string = ip = frameHandler.context.ip != null ? frameHandler.context.ip : IOHelper.getIP((SocketAddress)channel.remoteAddress());
            if (!client.isAuth) {
                LogHelper.info((String)"Channel %s | connectUUID %s | checkSign %s", (Object[])new Object[]{ip, frameHandler.getConnectUUID(), client.checkSign ? "true" : "false"});
            } else {
                LogHelper.info((String)"Client name %s | ip %s | connectUUID %s", (Object[])new Object[]{client.username == null ? "null" : client.username, ip, frameHandler.getConnectUUID()});
                LogHelper.subInfo((String)"userUUID: %s | session %s", (Object[])new Object[]{client.uuid == null ? "null" : client.uuid.toString(), client.session == null ? "null" : client.session});
                LogHelper.subInfo((String)"Data: checkSign %s | auth_id %s", (Object[])new Object[]{client.checkSign ? "true" : "false", client.auth_id});
                if (client.trustLevel != null) {
                    LogHelper.subInfo((String)"trustLevel | key %s | pubkey %s", (Object[])new Object[]{client.trustLevel.keyChecked ? "checked" : "unchecked", client.trustLevel.publicKey == null ? "null" : (Object)Base64.getEncoder().encode(client.trustLevel.publicKey)});
                }
                LogHelper.subInfo((String)"Permissions: %s (permissions %d | flags %d)", (Object[])new Object[]{client.permissions == null ? "null" : client.permissions.toString(), client.permissions == null ? 0L : client.permissions.permissions, client.permissions == null ? 0L : client.permissions.flags});
            }
        });
    }
}

