/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import java.util.StringTokenizer;
import org.fusesource.jansi.Ansi;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.handler.MemoryAuthHandler;
import pro.gravit.launchserver.auth.protect.AdvancedProtectHandler;
import pro.gravit.launchserver.auth.protect.NoProtectHandler;
import pro.gravit.launchserver.auth.protect.StdProtectHandler;
import pro.gravit.launchserver.auth.provider.AcceptAuthProvider;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.utils.helper.FormatHelper;
import pro.gravit.utils.helper.LogHelper;

public class SecurityCheckCommand
extends Command {
    public SecurityCheckCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[]";
    }

    public String getUsageDescription() {
        return "check configuration";
    }

    public void invoke(String ... args) throws Exception {
        LaunchServerConfig config = this.server.config;
        config.auth.forEach((name, pair) -> {
            if (pair.provider instanceof AcceptAuthProvider) {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, String.format("auth.%s.provider", name), "Accept auth provider", false);
            } else {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, String.format("auth.%s.provider", name), "", true);
            }
            if (pair.handler instanceof MemoryAuthHandler) {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, String.format("auth.%s.handler", name), "MemoryAuthHandler test-only", false);
            } else {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, String.format("auth.%s.handler", name), "", true);
            }
        });
        if (config.protectHandler instanceof NoProtectHandler) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "protectHandler", "protectHandler none", false);
        } else if (config.protectHandler instanceof AdvancedProtectHandler) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "protectHandler", "", true);
            if (!((AdvancedProtectHandler)config.protectHandler).enableHardwareFeature) {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "protectHandler.hardwareId", "you can improve security by using hwid provider", null);
            } else {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "protectHandler.hardwareId", "", true);
            }
        } else if (config.protectHandler instanceof StdProtectHandler) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "protectHandler", "you can improve security by using advanced", null);
        } else {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "protectHandler", "unknown protectHandler", null);
        }
        if (config.netty.address.startsWith("ws://")) {
            if (config.netty.ipForwarding) {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.ipForwarding", "ipForwarding may be used to spoofing ip", null);
            }
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.address", "websocket connection not secure", false);
        } else if (config.netty.address.startsWith("wss://")) {
            if (!config.netty.ipForwarding) {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.ipForwarding", "ipForwarding not enabled. authLimiter may be get incorrect ip", null);
            }
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.address", "", true);
        }
        if (config.netty.sendExceptionEnabled) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.sendExceptionEnabled", "recommend \"false\" in production", false);
        } else {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.sendExceptionEnabled", "", true);
        }
        if (config.netty.launcherURL.startsWith("http://")) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.launcherUrl", "launcher jar download connection not secure", false);
        } else if (config.netty.launcherURL.startsWith("https://")) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.launcherUrl", "", true);
        }
        if (config.netty.launcherEXEURL.startsWith("http://")) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.launcherExeUrl", "launcher exe download connection not secure", false);
        } else if (config.netty.launcherEXEURL.startsWith("https://")) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.launcherExeUrl", "", true);
        }
        if (config.netty.downloadURL.startsWith("http://")) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.downloadUrl", "assets/clients download connection not secure", false);
        } else if (config.netty.downloadURL.startsWith("https://")) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "netty.downloadUrl", "", true);
        }
        if (!config.sign.enabled) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "sign", "it is recommended to use a signature", null);
        } else {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "sign", "", true);
        }
        if (!config.launcher.enabledProGuard) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "launcher.enabledProGuard", "proguard not enabled", false);
        } else {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "launcher.enabledProGuard", "", true);
        }
        if (!config.launcher.stripLineNumbers) {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "launcher.stripLineNumbers", "stripLineNumbers not enabled", false);
        } else {
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "launcher.stripLineNumbers", "", true);
        }
        switch (config.env) {
            case DEV: {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "env", "found env DEV", false);
                break;
            }
            case DEBUG: {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "env", "found env DEBUG", false);
                break;
            }
            case STD: {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "env", "you can improve security by using env PROD", null);
                break;
            }
            case PROD: {
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, "env", "", true);
            }
        }
        for (ClientProfile profile : this.server.getProfiles()) {
            boolean bad = false;
            String profileModuleName = String.format("profiles.%s", profile.getTitle());
            for (String exc : profile.getUpdateExclusions()) {
                StringTokenizer tokenizer = new StringTokenizer(exc, "/");
                if (exc.endsWith(".jar")) {
                    SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, profileModuleName, String.format("updateExclusions %s not safe. Cheats may be injected very easy!", exc), false);
                    bad = true;
                    continue;
                }
                if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equals("mods")) continue;
                String nextToken = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) {
                    if (exc.endsWith("/")) continue;
                    SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, profileModuleName, String.format("updateExclusions %s not safe. Cheats may be injected very easy!", exc), false);
                    bad = true;
                    continue;
                }
                if (!nextToken.equals("memory_repo") && !nextToken.equals(profile.getVersion().name)) continue;
                SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, profileModuleName, String.format("updateExclusions %s not safe. Cheats may be injected very easy!", exc), false);
                bad = true;
            }
            if (bad) continue;
            SecurityCheckCommand.printCheckResult(LogHelper.Level.INFO, profileModuleName, "", true);
        }
        LogHelper.info((String)"Check completed");
    }

    public static void printCheckResult(LogHelper.Level level, String module, String comment, Boolean status) {
        LogHelper.rawLog(() -> FormatHelper.rawFormat((LogHelper.Level)level, (String)LogHelper.getDataTime(), (boolean)false).concat(String.format("[%s] %s - %s", module, comment, status == null ? "WARN" : (status != false ? "OK" : "FAIL"))), () -> FormatHelper.rawAnsiFormat((LogHelper.Level)level, (String)LogHelper.getDataTime(), (boolean)false).fgBright(Ansi.Color.WHITE).a("[").fgBright(Ansi.Color.BLUE).a(module).fgBright(Ansi.Color.WHITE).a("] ".concat(comment).concat(" - ")).fgBright(status == null ? Ansi.Color.YELLOW : (status != false ? Ansi.Color.GREEN : Ansi.Color.RED)).a(status == null ? "WARN" : (status != false ? "OK" : "FAIL")).reset().toString());
    }
}

