/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import pro.gravit.launcher.HTTPRequest;
import pro.gravit.utils.HttpDownloader;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class MirrorManager {
    protected final ArrayList<Mirror> list = new ArrayList();
    private Mirror defaultMirror;

    public void addMirror(String mirror) {
        Mirror m = new Mirror(mirror);
        m.enabled = true;
        if (this.defaultMirror == null) {
            this.defaultMirror = m;
        }
        this.list.add(m);
    }

    public void addMirror(String mirror, boolean enabled) {
        Mirror m = new Mirror(mirror);
        m.enabled = enabled;
        if (this.defaultMirror == null && enabled) {
            this.defaultMirror = m;
        }
        this.list.add(m);
    }

    public Mirror getDefaultMirror() {
        return this.defaultMirror;
    }

    public void setDefaultMirror(Mirror m) {
        this.defaultMirror = m;
    }

    public void disableMirror(int index) {
        this.list.get((int)index).enabled = false;
    }

    public void enableMirror(int index) {
        this.list.get((int)index).enabled = true;
    }

    public int size() {
        return this.list.size();
    }

    public boolean downloadZip(Mirror mirror, Path path, String mask, Object ... args) throws IOException {
        if (!mirror.enabled) {
            return false;
        }
        URL url = mirror.getURL(mask, args);
        LogHelper.debug((String)"Try download %s", (Object[])new Object[]{url.toString()});
        try {
            HttpDownloader.downloadZip((URL)url, (Path)path);
        }
        catch (IOException e) {
            LogHelper.error((String)"Download %s failed(%s: %s)", (Object[])new Object[]{url.toString(), e.getClass().getName(), e.getMessage()});
            return false;
        }
        return true;
    }

    public void downloadZip(Path path, String mask, Object ... args) throws IOException {
        if (this.downloadZip(this.defaultMirror, path, mask, args)) {
            return;
        }
        for (Mirror mirror : this.list) {
            if (mirror == this.defaultMirror || !this.downloadZip(mirror, path, mask, args)) continue;
            return;
        }
        throw new IOException(String.format("Error download %s. All mirrors return error", path.toString()));
    }

    public JsonElement jsonRequest(Mirror mirror, JsonElement request, String method, String mask, Object ... args) throws IOException {
        if (!mirror.enabled) {
            return null;
        }
        URL url = mirror.getURL(mask, args);
        try {
            return HTTPRequest.jsonRequest((JsonElement)request, (String)method, (URL)url);
        }
        catch (IOException e) {
            LogHelper.error((String)"JsonRequest %s failed(%s: %s)", (Object[])new Object[]{url.toString(), e.getClass().getName(), e.getMessage()});
            return null;
        }
    }

    public JsonElement jsonRequest(JsonElement request, String method, String mask, Object ... args) throws IOException {
        JsonElement result = this.jsonRequest(this.defaultMirror, request, method, mask, args);
        if (result != null) {
            return result;
        }
        for (Mirror mirror : this.list) {
            if (mirror == this.defaultMirror || (result = this.jsonRequest(mirror, request, method, mask, args)) == null) continue;
            return result;
        }
        throw new IOException("Error jsonRequest. All mirrors return error");
    }

    public static class Mirror {
        final String baseUrl;
        boolean enabled;

        Mirror(String url) {
            this.baseUrl = url;
        }

        private URL formatArgs(String mask, Object ... args) throws MalformedURLException {
            Object[] data = Arrays.stream(args).map(e -> IOHelper.urlEncode((String)e.toString())).toArray();
            return new URL(this.baseUrl.concat(String.format(mask, data)));
        }

        public URL getURL(String mask, Object ... args) throws MalformedURLException {
            return this.formatArgs(mask, args);
        }
    }
}

