/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.dao.User;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;

public class Client {
    public UUID session;
    public String auth_id;
    public long timestamp;
    public AuthResponse.ConnectTypes type;
    public ClientProfile profile;
    public boolean isAuth;
    public boolean checkSign;
    public ClientPermissions permissions;
    public String username;
    public UUID uuid;
    public TrustLevel trustLevel;
    public transient AuthProviderPair auth;
    public transient User daoObject;
    public transient Map<String, Object> properties;
    public transient AtomicInteger refCount = new AtomicInteger(1);

    public Client(UUID session) {
        this.session = session;
        this.timestamp = System.currentTimeMillis();
        this.type = null;
        this.isAuth = false;
        this.permissions = ClientPermissions.DEFAULT;
        this.username = "";
        this.checkSign = false;
    }

    public void up() {
        this.timestamp = System.currentTimeMillis();
    }

    public void updateAuth(LaunchServer server) {
        if (!this.isAuth) {
            return;
        }
        this.auth = this.auth_id.isEmpty() ? server.config.getAuthProviderPair() : server.config.getAuthProviderPair(this.auth_id);
    }

    public <T> T getProperty(String name) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return (T)this.properties.get(name);
    }

    public <T> void setProperty(String name, T object) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, object);
    }

    public static class TrustLevel {
        public byte[] verifySecureKey;
        public boolean keyChecked;
        public byte[] publicKey;
        public HardwareReportRequest.HardwareInfo hardwareInfo;
    }

    public static enum Type {
        SERVER,
        USER;

    }
}

