/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import java.util.Comparator;
import java.util.TreeSet;
import pro.gravit.launchserver.socket.NettyConnectContext;

public class NettyWebAPIHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final NettyConnectContext context;
    private static final TreeSet<SeverletPathPair> severletList = new TreeSet<SeverletPathPair>(Comparator.comparingInt(e -> -e.key.length()));

    public NettyWebAPIHandler(NettyConnectContext context) {
        this.context = context;
    }

    public static SeverletPathPair addNewSeverlet(String path, SimpleSeverletHandler callback) {
        SeverletPathPair pair = new SeverletPathPair("/webapi/".concat(path), callback);
        severletList.add(pair);
        return pair;
    }

    public static SeverletPathPair addUnsafeSeverlet(String path, SimpleSeverletHandler callback) {
        SeverletPathPair pair = new SeverletPathPair(path, callback);
        severletList.add(pair);
        return pair;
    }

    public static void removeSeverlet(SeverletPathPair pair) {
        severletList.remove(pair);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        boolean isNext = true;
        for (SeverletPathPair pair : severletList) {
            if (!msg.uri().startsWith(pair.key)) continue;
            pair.callback.handle(ctx, msg, this.context);
            isNext = false;
            break;
        }
        if (isNext) {
            msg.retain();
            ctx.fireChannelRead((Object)msg);
        }
    }

    public static class SeverletPathPair {
        public final String key;
        public final SimpleSeverletHandler callback;

        public SeverletPathPair(String key, SimpleSeverletHandler callback) {
            this.key = key;
            this.callback = callback;
        }
    }

    @FunctionalInterface
    public static interface SimpleSeverletHandler {
        public void handle(ChannelHandlerContext var1, FullHttpRequest var2, NettyConnectContext var3) throws Exception;
    }
}

