/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.CheckServerRequestEvent;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.launchserver.socket.response.profile.ProfileByUUIDResponse;
import pro.gravit.utils.HookException;
import pro.gravit.utils.helper.LogHelper;

public class CheckServerResponse
extends SimpleResponse {
    public String serverID;
    public String username;
    public String client;

    @Override
    public String getType() {
        return "checkServer";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client pClient) {
        if (!pClient.isAuth || pClient.type == AuthResponse.ConnectTypes.CLIENT) {
            this.sendError("Permissions denied");
            return;
        }
        CheckServerRequestEvent result = new CheckServerRequestEvent();
        try {
            this.server.authHookManager.checkServerHook.hook((Object)this, (Object)pClient);
            result.uuid = pClient.auth.handler.checkServer(this.username, this.serverID);
            if (result.uuid != null) {
                result.playerProfile = ProfileByUUIDResponse.getProfile(result.uuid, this.username, this.client, pClient.auth.textureProvider);
            }
            if (LogHelper.isDebugEnabled()) {
                LogHelper.debug((String)"checkServer: %s uuid: %s serverID: %s", (Object[])new Object[]{result.playerProfile.username, result.uuid.toString(), this.serverID});
            }
        }
        catch (AuthException | HookException e) {
            this.sendError(e.getMessage());
            return;
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            this.sendError("Internal authHandler error");
            return;
        }
        this.sendResult((RequestEvent)result);
    }
}

