/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.SetProfileRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.auth.protect.interfaces.ProfilesProtectHandler;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.utils.HookException;

public class SetProfileResponse
extends SimpleResponse {
    public String client;

    @Override
    public String getType() {
        return "setProfile";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        try {
            this.server.authHookManager.setProfileHook.hook((Object)this, (Object)client);
        }
        catch (HookException e) {
            this.sendError(e.getMessage());
        }
        List<ClientProfile> profiles = this.server.getProfiles();
        for (ClientProfile p : profiles) {
            if (!p.getTitle().equals(this.client)) continue;
            if (this.server.config.protectHandler instanceof ProfilesProtectHandler && !((ProfilesProtectHandler)((Object)this.server.config.protectHandler)).canChangeProfile(p, client)) {
                this.sendError("Access denied");
                return;
            }
            client.profile = p;
            this.sendResult((RequestEvent)new SetProfileRequestEvent(p));
            return;
        }
        this.sendError("Profile not found");
    }
}

