/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.profile;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.UUID;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.texture.TextureProvider;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.utils.helper.LogHelper;

public class ProfileByUUIDResponse
extends SimpleResponse {
    public UUID uuid;
    public String client;

    public static PlayerProfile getProfile(UUID uuid, String username, String client, TextureProvider textureProvider) {
        Texture cloak;
        Texture skin;
        try {
            skin = textureProvider.getSkinTexture(uuid, username, client);
        }
        catch (IOException e) {
            LogHelper.error((Throwable)new IOException(String.format("Can't get skin texture: '%s'", username), e));
            skin = null;
        }
        try {
            cloak = textureProvider.getCloakTexture(uuid, username, client);
        }
        catch (IOException e) {
            LogHelper.error((Throwable)new IOException(String.format("Can't get cloak texture: '%s'", username), e));
            cloak = null;
        }
        return new PlayerProfile(uuid, username, skin, cloak);
    }

    @Override
    public String getType() {
        return "profileByUUID";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) throws Exception {
        AuthProviderPair pair = client.auth == null ? this.server.config.getAuthProviderPair() : client.auth;
        if (pair == null) {
            this.sendError("ProfileByUUIDResponse: AuthProviderPair is null");
            return;
        }
        String username = pair.handler.uuidToUsername(this.uuid);
        if (username == null) {
            this.sendError(String.format("ProfileByUUIDResponse: User with uuid %s not found or AuthProvider#uuidToUsername returned null", this.uuid));
            return;
        }
        this.sendResult((RequestEvent)new ProfileByUUIDRequestEvent(ProfileByUUIDResponse.getProfile(this.uuid, username, this.client, pair.textureProvider)));
    }
}

