/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.session;

import java.util.UUID;
import java.util.stream.Stream;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.session.MemorySessionStorage;
import pro.gravit.utils.ProviderMap;

public abstract class SessionStorage {
    public static ProviderMap<SessionStorage> providers = new ProviderMap();
    private static boolean registeredProviders = false;
    protected transient LaunchServer server;

    public static void registerProviders() {
        if (!registeredProviders) {
            providers.register("memory", MemorySessionStorage.class);
            registeredProviders = true;
        }
    }

    public abstract byte[] getSessionData(UUID var1);

    public abstract Stream<UUID> getSessionsFromUserUUID(UUID var1);

    public abstract boolean writeSession(UUID var1, UUID var2, byte[] var3);

    public abstract boolean deleteSession(UUID var1);

    public boolean deleteSessionsByUserUUID(UUID userUUID) {
        this.getSessionsFromUserUUID(userUUID).forEach(this::deleteSession);
        return true;
    }

    public abstract void clear();

    public abstract void lockSession(UUID var1);

    public abstract void lockUser(UUID var1);

    public abstract void unlockSession(UUID var1);

    public abstract void unlockUser(UUID var1);

    public void init(LaunchServer server) {
        this.server = server;
    }
}

