/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.auth;

import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.launchserver.command.Command;

public final class AuthCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public AuthCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "<login> <password> <auth_id>";
    }

    public String getUsageDescription() {
        return "Try to auth with specified login and password";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 2);
        AuthProviderPair pair = args.length > 2 ? this.server.config.getAuthProviderPair(args[2]) : this.server.config.getAuthProviderPair();
        if (pair == null) {
            throw new IllegalStateException(String.format("Auth %s not found", args[1]));
        }
        if (pair.isUseCore()) {
            throw new UnsupportedOperationException(String.format("Please use `config auth.%s.core COMMAND ARGS`", pair.name));
        }
        String login = args[0];
        String password = args[1];
        AuthProvider provider = pair.provider;
        AuthProviderResult result = provider.auth(login, (AuthRequest.AuthPasswordInterface)new AuthPlainPassword(password), "127.0.0.1");
        UUID uuid = pair.handler.auth(result);
        this.logger.info("UUID: {}, Username: '{}', Access Token: '{}'", (Object)uuid, (Object)result.username, (Object)result.accessToken);
    }
}

