/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.auth;

import java.io.IOException;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.command.CommandException;

public final class UUIDToUsernameCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public UUIDToUsernameCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "<uuid> <auth_id>";
    }

    public String getUsageDescription() {
        return "Convert player UUID to username";
    }

    public void invoke(String ... args) throws CommandException, IOException {
        this.verifyArgs(args, 1);
        AuthProviderPair pair = args.length > 1 ? this.server.config.getAuthProviderPair(args[1]) : this.server.config.getAuthProviderPair();
        if (pair == null) {
            throw new IllegalStateException(String.format("Auth %s not found", args[1]));
        }
        if (pair.isUseCore()) {
            throw new UnsupportedOperationException(String.format("Please use `config auth.%s.core COMMAND ARGS`", pair.name));
        }
        UUID uuid = UUIDToUsernameCommand.parseUUID((String)args[0]);
        String username = pair.handler.uuidToUsername(uuid);
        if (username == null) {
            throw new CommandException("Unknown UUID: " + uuid);
        }
        this.logger.info("Username of player {}: '{}'", (Object)uuid, (Object)username);
    }
}

