/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClassPath;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClientArgs;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionFile;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionJvmArgs;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.helper.IOHelper;

public class SaveProfilesCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public SaveProfilesCommand(LaunchServer server) {
        super(server);
    }

    public static void saveProfile(ClientProfile profile, Path path) throws IOException {
        if (profile.getUUID() == null) {
            profile.setUUID(UUID.randomUUID());
        }
        if (profile.getServers().size() == 0) {
            ClientProfile.ServerProfile serverProfile = new ClientProfile.ServerProfile();
            serverProfile.isDefault = true;
            serverProfile.name = profile.getTitle();
            serverProfile.serverAddress = profile.getServerAddress();
            serverProfile.serverPort = profile.getServerPort();
            profile.getServers().add(serverProfile);
        }
        block11: for (OptionalFile file : profile.getOptional()) {
            if (file.list != null) {
                OptionalActionClassPath action;
                String[] list = file.list;
                file.list = null;
                if (file.actions == null) {
                    file.actions = new ArrayList(2);
                }
                switch (file.type) {
                    case FILE: {
                        OptionalActionFile result = new OptionalActionFile(new HashMap());
                        for (String s : list) {
                            result.files.put(s, "");
                        }
                        action = result;
                        break;
                    }
                    case CLASSPATH: {
                        action = new OptionalActionClassPath(list);
                        break;
                    }
                    case JVMARGS: {
                        action = new OptionalActionJvmArgs(Arrays.asList(list));
                        break;
                    }
                    case CLIENTARGS: {
                        action = new OptionalActionClientArgs(Arrays.asList(list));
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                file.actions.add(action);
            }
            if (file.triggers == null) continue;
            file.triggersList = new ArrayList(file.triggers.length);
            for (pro.gravit.launcher.profiles.optional.OptionalTrigger trigger : file.triggers) {
                OptionalTrigger newTrigger = trigger.toTrigger();
                if (newTrigger == null) continue;
                file.triggersList.add(newTrigger);
            }
            file.triggers = null;
        }
        try (BufferedWriter w = IOHelper.newWriter((Path)path);){
            Launcher.gsonManager.configGson.toJson((Object)profile, (Appendable)w);
        }
    }

    public String getArgsDescription() {
        return "[profile names...]";
    }

    public String getUsageDescription() {
        return "load and save profile";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        if (args.length > 0) {
            for (String profileName : args) {
                ClientProfile profile;
                Path profilePath = this.server.profilesDir.resolve(profileName.concat(".json"));
                if (!Files.exists(profilePath, new LinkOption[0])) {
                    this.logger.error("Profile {} not found", (Object)profilePath.toString());
                    return;
                }
                try (BufferedReader reader = IOHelper.newReader((Path)profilePath);){
                    profile = (ClientProfile)Launcher.gsonManager.configGson.fromJson((Reader)reader, ClientProfile.class);
                }
                SaveProfilesCommand.saveProfile(profile, profilePath);
                this.logger.info("Profile {} save successful", (Object)profilePath.toString());
            }
            this.server.syncProfilesDir();
        }
    }
}

