/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import java.net.SocketAddress;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.WebSocketService;
import pro.gravit.launchserver.socket.handlers.WebSocketFrameHandler;
import pro.gravit.utils.helper.IOHelper;

public class ClientsCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public ClientsCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return null;
    }

    public String getUsageDescription() {
        return "Show all connected clients";
    }

    public void invoke(String ... args) {
        WebSocketService service = this.server.nettyServerSocketHandler.nettyServer.service;
        service.channels.forEach(channel -> {
            String ip;
            WebSocketFrameHandler frameHandler = (WebSocketFrameHandler)channel.pipeline().get(WebSocketFrameHandler.class);
            if (frameHandler == null) {
                this.logger.info("Channel {}", (Object)IOHelper.getIP((SocketAddress)channel.remoteAddress()));
                return;
            }
            Client client = frameHandler.getClient();
            String string = ip = frameHandler.context.ip != null ? frameHandler.context.ip : IOHelper.getIP((SocketAddress)channel.remoteAddress());
            if (!client.isAuth) {
                this.logger.info("Channel {} | connectUUID {} | checkSign {}", (Object)ip, (Object)frameHandler.getConnectUUID(), (Object)(client.checkSign ? "true" : "false"));
            } else {
                this.logger.info("Client name {} | ip {} | connectUUID {}", (Object)(client.username == null ? "null" : client.username), (Object)ip, (Object)frameHandler.getConnectUUID());
                this.logger.info("userUUID: {} | session {}", (Object)(client.uuid == null ? "null" : client.uuid.toString()), client.session == null ? "null" : client.session);
                this.logger.info("OAuth {} | session {}", (Object)client.useOAuth, client.sessionObject == null ? "null" : client.sessionObject);
                this.logger.info("Data: checkSign {} | auth_id {}", (Object)(client.checkSign ? "true" : "false"), (Object)client.auth_id);
                if (client.trustLevel != null) {
                    this.logger.info("trustLevel | key {} | pubkey {}", (Object)(client.trustLevel.keyChecked ? "checked" : "unchecked"), (Object)(client.trustLevel.publicKey == null ? "null" : new String(Base64.getEncoder().encode(client.trustLevel.publicKey))));
                }
                this.logger.info("Permissions: {} (permissions {} | flags {})", (Object)(client.permissions == null ? "null" : client.permissions.toString()), (Object)(client.permissions == null ? 0L : client.permissions.permissions), (Object)(client.permissions == null ? 0L : client.permissions.flags));
            }
        });
    }
}

