/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.config;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.utils.helper.SecurityHelper;

public class LaunchServerRuntimeConfig {
    private final transient Logger logger = LogManager.getLogger();
    public String passwordEncryptKey;
    public String runtimeEncryptKey;
    public String oemUnlockKey;
    public String registerApiKey;
    public String clientCheckSecret;

    public void verify() {
        if (this.passwordEncryptKey == null) {
            this.logger.error("[RuntimeConfig] passwordEncryptKey must not be null");
        }
        if (this.clientCheckSecret == null) {
            this.logger.warn("[RuntimeConfig] clientCheckSecret must not be null");
            this.clientCheckSecret = SecurityHelper.randomStringToken();
        }
    }

    public void reset() {
        this.passwordEncryptKey = SecurityHelper.randomStringToken();
        this.runtimeEncryptKey = SecurityHelper.randomStringAESKey();
        this.registerApiKey = SecurityHelper.randomStringToken();
        this.clientCheckSecret = SecurityHelper.randomStringToken();
    }
}

