/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.provider;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.MySQLSourceConfig;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class MySQLAuthProvider
extends AuthProvider {
    private MySQLSourceConfig mySQLHolder;
    private String query;
    private String message;
    private String[] queryParams;
    private boolean flagsEnabled;

    @Override
    public void init(LaunchServer srv) {
        super.init(srv);
        if (this.query == null) {
            throw new RuntimeException("[Verify][AuthProvider] query cannot be null");
        }
        if (this.message == null) {
            throw new RuntimeException("[Verify][AuthProvider] message cannot be null");
        }
        if (this.mySQLHolder == null) {
            throw new RuntimeException("[Verify][AuthProvider] mySQLHolder cannot be null");
        }
    }

    @Override
    public AuthProviderResult auth(String login, AuthRequest.AuthPasswordInterface password, String ip) throws SQLException, AuthException {
        if (!(password instanceof AuthPlainPassword)) {
            throw new AuthException("This password type not supported");
        }
        try (Connection c = this.mySQLHolder.getConnection();){
            AuthProviderResult authProviderResult;
            block14: {
                PreparedStatement s = c.prepareStatement(this.query);
                String[] replaceParams = new String[]{"login", login, "password", ((AuthPlainPassword)password).password, "ip", ip};
                for (int i = 0; i < this.queryParams.length; ++i) {
                    s.setString(i + 1, CommonHelper.replace((String)this.queryParams[i], (String[])replaceParams));
                }
                s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                ResultSet set = s.executeQuery();
                try {
                    AuthProviderResult authProviderResult2 = set.next() ? new AuthProviderResult(set.getString(1), SecurityHelper.randomStringToken(), new ClientPermissions(set.getLong(2), this.flagsEnabled ? set.getLong(3) : 0L)) : (authProviderResult = MySQLAuthProvider.authError(this.message));
                    if (set == null) break block14;
                }
                catch (Throwable throwable) {
                    if (set != null) {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                set.close();
            }
            return authProviderResult;
        }
    }

    @Override
    public void close() {
        this.mySQLHolder.close();
    }
}

