/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.SecurityHelper;

public final class RejectAuthProvider
extends AuthProvider
implements Reconfigurable {
    private final transient Logger logger = LogManager.getLogger();
    public String message;
    public ArrayList<String> whitelist = new ArrayList();

    public RejectAuthProvider() {
    }

    public RejectAuthProvider(String message) {
        this.message = message;
    }

    @Override
    public AuthProviderResult auth(String login, AuthRequest.AuthPasswordInterface password, String ip) throws AuthException {
        if (this.whitelist != null) {
            for (String username : this.whitelist) {
                if (!login.equals(username)) continue;
                return new AuthProviderResult(login, SecurityHelper.randomStringToken(), ClientPermissions.DEFAULT);
            }
        }
        return RejectAuthProvider.authError(this.message);
    }

    @Override
    public void close() {
    }

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("message", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                RejectAuthProvider.this.message = args[0];
                RejectAuthProvider.this.logger.info("New reject message: {}", (Object)RejectAuthProvider.this.message);
            }
        });
        commands.put("whitelist.add", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                RejectAuthProvider.this.whitelist.add(args[0]);
                RejectAuthProvider.this.logger.info("{} added to whitelist", (Object)args[0]);
            }
        });
        return commands;
    }
}

