/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.UnpackHelper;

public class PrepareBuildTask
implements LauncherBuildTask {
    private final LaunchServer server;
    private final Path result;
    private final transient Logger logger = LogManager.getLogger();

    public PrepareBuildTask(LaunchServer server) {
        this.server = server;
        this.result = server.launcherBinary.buildDir.resolve("Launcher-clean.jar");
    }

    @Override
    public String getName() {
        return "UnpackFromResources";
    }

    @Override
    public Path process(Path inputFile) throws IOException {
        this.server.launcherBinary.coreLibs.clear();
        this.server.launcherBinary.addonLibs.clear();
        IOHelper.walk((Path)this.server.launcherLibraries, (FileVisitor)new ListFileVisitor(this.server.launcherBinary.coreLibs), (boolean)true);
        IOHelper.walk((Path)this.server.launcherLibrariesCompile, (FileVisitor)new ListFileVisitor(this.server.launcherBinary.addonLibs), (boolean)true);
        UnpackHelper.unpack((URL)IOHelper.getResourceURL((String)"Launcher.jar"), (Path)this.result);
        this.tryUnpack();
        return this.result;
    }

    @Override
    public boolean allowDelete() {
        return false;
    }

    public void tryUnpack() throws IOException {
        this.logger.info("Unpacking launcher native guard list and runtime");
        UnpackHelper.unpackZipNoCheck((String)"guard.zip", (Path)this.server.launcherBinary.guardDir);
        UnpackHelper.unpackZipNoCheck((String)"runtime.zip", (Path)this.server.launcherBinary.runtimeDir);
    }

    private static final class ListFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Path> lst;

        private ListFileVisitor(List<Path> lst) {
            this.lst = lst;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!Files.isDirectory(file, new LinkOption[0]) && file.toFile().getName().endsWith(".jar")) {
                this.lst.add(file);
            }
            return super.visitFile(file, attrs);
        }
    }
}

