/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.secure;

import io.netty.channel.ChannelHandlerContext;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launchserver.auth.protect.interfaces.SecureProtectHandler;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;

public class VerifySecureLevelKeyResponse
extends SimpleResponse {
    public byte[] publicKey;
    public byte[] signature;

    @Override
    public String getType() {
        return "verifySecureLevelKey";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        if (!(this.server.config.protectHandler instanceof SecureProtectHandler) || client.trustLevel == null || client.trustLevel.verifySecureKey == null) {
            this.sendError("This method not allowed");
            return;
        }
        SecureProtectHandler secureProtectHandler = (SecureProtectHandler)((Object)this.server.config.protectHandler);
        try {
            secureProtectHandler.verifySecureLevelKey(this.publicKey, client.trustLevel.verifySecureKey, this.signature);
        }
        catch (InvalidKeySpecException e) {
            this.sendError("Invalid public key");
            return;
        }
        catch (SignatureException e) {
            this.sendError("Invalid signature");
            return;
        }
        catch (SecurityException e) {
            this.sendError(e.getMessage());
            return;
        }
        client.trustLevel.keyChecked = true;
        client.trustLevel.publicKey = this.publicKey;
        try {
            this.sendResult((RequestEvent)secureProtectHandler.onSuccessVerify(client));
        }
        catch (SecurityException e) {
            this.sendError(e.getMessage());
        }
    }
}

