/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core.interfaces.provider;

import java.util.Arrays;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.UserHardware;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupport;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportHardware;
import pro.gravit.launchserver.helper.DamerauHelper;

public interface AuthSupportHardware
extends AuthSupport {
    public UserHardware getHardwareInfoByPublicKey(byte[] var1);

    public UserHardware getHardwareInfoByData(HardwareReportRequest.HardwareInfo var1);

    public UserHardware getHardwareInfoById(String var1);

    public UserHardware createHardwareInfo(HardwareReportRequest.HardwareInfo var1, byte[] var2);

    public void connectUserAndHardware(UserSession var1, UserHardware var2);

    public void addPublicKeyToHardwareInfo(UserHardware var1, byte[] var2);

    public Iterable<User> getUsersByHardwareInfo(UserHardware var1);

    public void banHardware(UserHardware var1);

    public void unbanHardware(UserHardware var1);

    default public UserSupportHardware fetchUserHardware(User user) {
        return (UserSupportHardware)((Object)user);
    }

    default public void normalizeHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo) {
        if (hardwareInfo.baseboardSerialNumber != null) {
            hardwareInfo.baseboardSerialNumber = hardwareInfo.baseboardSerialNumber.trim();
        }
        if (hardwareInfo.hwDiskId != null) {
            hardwareInfo.hwDiskId = hardwareInfo.hwDiskId.trim();
        }
    }

    default public HardwareInfoCompareResult compareHardwareInfo(HardwareReportRequest.HardwareInfo first, HardwareReportRequest.HardwareInfo second) {
        HardwareInfoCompareResult result = new HardwareInfoCompareResult();
        if (first.hwDiskId == null || first.hwDiskId.isEmpty()) {
            result.firstSpoofingLevel += 0.9;
        }
        if (first.displayId == null || first.displayId.length < 4) {
            result.firstSpoofingLevel += 0.3;
        }
        if (first.baseboardSerialNumber == null || first.baseboardSerialNumber.trim().isEmpty()) {
            result.firstSpoofingLevel += 0.2;
        }
        if (second.hwDiskId == null || second.hwDiskId.trim().isEmpty()) {
            result.secondSpoofingLevel += 0.9;
        }
        if (second.displayId == null || second.displayId.length < 4) {
            result.secondSpoofingLevel += 0.3;
        }
        if (second.baseboardSerialNumber == null || second.baseboardSerialNumber.trim().isEmpty()) {
            result.secondSpoofingLevel += 0.2;
        }
        if (first.hwDiskId != null && second.hwDiskId != null) {
            double addLevel;
            int hwDIskIdRate = DamerauHelper.calculateDistance(first.hwDiskId.toLowerCase(), second.hwDiskId.toLowerCase());
            if (hwDIskIdRate == 0) {
                result.compareLevel += 0.99;
            } else if (hwDIskIdRate < 3) {
                result.compareLevel += 0.85;
            } else if (hwDIskIdRate < (first.hwDiskId.length() + second.hwDiskId.length()) / 4 && (addLevel = (double)hwDIskIdRate / ((double)(first.hwDiskId.length() + second.hwDiskId.length()) / 2.0)) > 0.0 && addLevel < 0.85) {
                result.compareLevel += addLevel;
            }
        }
        if (first.baseboardSerialNumber != null && second.baseboardSerialNumber != null) {
            int baseboardSerialRate = DamerauHelper.calculateDistance(first.baseboardSerialNumber.toLowerCase(), second.baseboardSerialNumber.toLowerCase());
            if (baseboardSerialRate == 0) {
                result.compareLevel += 0.3;
            } else if (baseboardSerialRate < 3) {
                result.compareLevel += 0.15;
            }
        }
        if (first.displayId != null && second.displayId != null && Arrays.equals(first.displayId, second.displayId)) {
            result.compareLevel += 0.75;
        }
        if (first.logicalProcessors == 0 || first.physicalProcessors == 0 || first.logicalProcessors < first.physicalProcessors) {
            result.firstSpoofingLevel += 0.9;
        }
        if (second.logicalProcessors == 0 || second.physicalProcessors == 0 || second.logicalProcessors < second.physicalProcessors) {
            result.secondSpoofingLevel += 0.9;
        }
        if (first.physicalProcessors == second.physicalProcessors && first.logicalProcessors == second.logicalProcessors) {
            result.compareLevel += 0.05;
        }
        if (first.battery != second.battery) {
            result.compareLevel -= 0.05;
        }
        if (first.processorMaxFreq == second.processorMaxFreq) {
            result.compareLevel += 0.1;
        }
        if (first.totalMemory == second.totalMemory) {
            result.compareLevel += 0.1;
        }
        if (Math.abs(first.totalMemory - second.totalMemory) < 32768L) {
            result.compareLevel += 0.05;
        }
        return result;
    }

    public static class HardwareInfoCompareResult {
        public double firstSpoofingLevel = 0.0;
        public double secondSpoofingLevel = 0.0;
        public double compareLevel;
    }
}

