/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.texture;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launchserver.auth.texture.JsonTextureProvider;
import pro.gravit.launchserver.auth.texture.NullTextureProvider;
import pro.gravit.launchserver.auth.texture.RequestTextureProvider;
import pro.gravit.launchserver.auth.texture.VoidTextureProvider;
import pro.gravit.utils.ProviderMap;

public abstract class TextureProvider
implements AutoCloseable {
    public static final ProviderMap<TextureProvider> providers = new ProviderMap("TextureProvider");
    private static boolean registredProv = false;

    public static void registerProviders() {
        if (!registredProv) {
            providers.register("null", NullTextureProvider.class);
            providers.register("void", VoidTextureProvider.class);
            providers.register("request", RequestTextureProvider.class);
            providers.register("json", JsonTextureProvider.class);
            registredProv = true;
        }
    }

    @Override
    public abstract void close() throws IOException;

    public abstract Texture getCloakTexture(UUID var1, String var2, String var3) throws IOException;

    public abstract Texture getSkinTexture(UUID var1, String var2, String var3) throws IOException;

    @Deprecated
    public SkinAndCloakTextures getTextures(UUID uuid, String username, String client) {
        Texture cloak;
        Texture skin;
        try {
            skin = this.getSkinTexture(uuid, username, client);
        }
        catch (IOException e) {
            skin = null;
        }
        try {
            cloak = this.getCloakTexture(uuid, username, client);
        }
        catch (IOException e) {
            cloak = null;
        }
        return new SkinAndCloakTextures(skin, cloak);
    }

    public Map<String, Texture> getAssets(UUID uuid, String username, String client) {
        Texture cloak;
        Texture skin;
        try {
            skin = this.getSkinTexture(uuid, username, client);
        }
        catch (IOException e) {
            skin = null;
        }
        try {
            cloak = this.getCloakTexture(uuid, username, client);
        }
        catch (IOException e) {
            cloak = null;
        }
        HashMap<String, Texture> map = new HashMap<String, Texture>();
        if (skin != null) {
            map.put("SKIN", skin);
        }
        if (cloak != null) {
            map.put("CAPE", cloak);
        }
        return map;
    }

    @Deprecated
    public static class SkinAndCloakTextures {
        public final Texture skin;
        public final Texture cloak;

        public SkinAndCloakTextures(Texture skin, Texture cloak) {
            this.skin = skin;
            this.cloak = cloak;
        }
    }
}

