/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.ExitRequestEvent;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportExit;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.handlers.WebSocketFrameHandler;
import pro.gravit.launchserver.socket.response.SimpleResponse;

public class ExitResponse
extends SimpleResponse {
    public boolean exitAll;
    public String username;

    public static void exit(LaunchServer server, WebSocketFrameHandler wsHandler, Channel channel, ExitRequestEvent.ExitReason reason) {
        Client chClient = wsHandler.getClient();
        Client newCusClient = new Client(null);
        newCusClient.checkSign = chClient.checkSign;
        wsHandler.setClient(newCusClient);
        if (chClient.session != null) {
            throw new UnsupportedOperationException("Legacy session system removed");
        }
        ExitRequestEvent event = new ExitRequestEvent(reason);
        event.requestUUID = RequestEvent.eventUUID;
        wsHandler.service.sendObject(channel, (Object)event);
    }

    @Override
    public String getType() {
        return "exit";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        if (!(this.username == null || client.isAuth && client.permissions != null && client.permissions.hasPerm("launchserver\\.management\\.kick"))) {
            this.sendError("Permissions denied");
            return;
        }
        if (this.username == null) {
            if (client.useOAuth) {
                WebSocketFrameHandler handler = (WebSocketFrameHandler)ctx.pipeline().get(WebSocketFrameHandler.class);
                if (handler == null) {
                    this.sendError("Exit internal error");
                    return;
                }
                Client newClient = new Client(null, 0);
                newClient.checkSign = client.checkSign;
                handler.setClient(newClient);
                AuthSupportExit supportExit = client.auth.core.isSupport(AuthSupportExit.class);
                if (supportExit != null) {
                    if (this.exitAll) {
                        supportExit.exitUser(client.getUser());
                    } else {
                        UserSession session = client.sessionObject;
                        if (session != null) {
                            supportExit.deleteSession(session);
                        }
                    }
                }
                this.sendResult((RequestEvent)new ExitRequestEvent(ExitRequestEvent.ExitReason.CLIENT));
            } else {
                if (client.session == null && this.exitAll) {
                    this.sendError("Session invalid");
                    return;
                }
                WebSocketFrameHandler handler = (WebSocketFrameHandler)ctx.pipeline().get(WebSocketFrameHandler.class);
                if (handler == null) {
                    this.sendError("Exit internal error");
                    return;
                }
                Client newClient = new Client(null);
                newClient.checkSign = client.checkSign;
                handler.setClient(newClient);
                if (client.session != null) {
                    throw new UnsupportedOperationException("Legacy session system removed");
                }
                if (this.exitAll) {
                    this.service.forEachActiveChannels((channel, webSocketFrameHandler) -> {
                        Client client1 = webSocketFrameHandler.getClient();
                        if (client.isAuth && client.username != null ? !client1.isAuth || !client.username.equals(client1.username) : client1.session != client.session) {
                            return;
                        }
                        ExitResponse.exit(this.server, webSocketFrameHandler, channel, ExitRequestEvent.ExitReason.SERVER);
                    });
                }
            }
            this.sendResult((RequestEvent)new ExitRequestEvent(ExitRequestEvent.ExitReason.CLIENT));
        } else {
            this.service.forEachActiveChannels((channel, webSocketFrameHandler) -> {
                Client client1 = webSocketFrameHandler.getClient();
                if (client1 != null && client.isAuth && client.username != null && client1.username.equals(this.username)) {
                    ExitResponse.exit(this.server, webSocketFrameHandler, channel, ExitRequestEvent.ExitReason.SERVER);
                }
            });
            this.sendResult((RequestEvent)new ExitRequestEvent(ExitRequestEvent.ExitReason.NO_EXIT));
        }
    }
}

