/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;

public final class StarterAgent {
    public static Instrumentation inst = null;
    public static Path libraries = null;
    private static boolean isStarted = false;

    public static boolean isAgentStarted() {
        return isStarted;
    }

    public static void premain(String agentArgument, Instrumentation inst) {
        StarterAgent.inst = inst;
        libraries = Paths.get(Optional.ofNullable(agentArgument).map(String::trim).filter(e -> !e.isEmpty()).orElse("libraries"), new String[0]);
        isStarted = true;
        try {
            Files.walkFileTree(libraries, Collections.singleton(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new StarterVisitor());
        }
        catch (IOException e2) {
            e2.printStackTrace(System.err);
        }
    }

    private static final class StarterVisitor
    extends SimpleFileVisitor<Path> {
        private static final Set<PosixFilePermission> DPERMS;
        private final boolean fixLib;

        private StarterVisitor() {
            Path filef = libraries.resolve(".libraries_chmoded");
            boolean bl = this.fixLib = !Files.exists(filef, new LinkOption[0]) && !Boolean.getBoolean("launcher.noLibrariesPosixPermsFix");
            if (this.fixLib) {
                try {
                    Files.deleteIfExists(filef);
                    Files.createFile(filef, new FileAttribute[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.fixLib && Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]) != null) {
                Files.setPosixFilePermissions(file, DPERMS);
            }
            if (file.toFile().getName().endsWith(".jar")) {
                inst.appendToSystemClassLoaderSearch(new JarFile(file.toFile()));
            }
            return super.visitFile(file, attrs);
        }

        static {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.values()));
            perms.remove((Object)PosixFilePermission.OTHERS_WRITE);
            perms.remove((Object)PosixFilePermission.GROUP_WRITE);
            DPERMS = Collections.unmodifiableSet(perms);
        }
    }
}

