/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.details.AuthPasswordDetails;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.core.HttpAuthCoreProvider;
import pro.gravit.launchserver.auth.core.MemoryAuthCoreProvider;
import pro.gravit.launchserver.auth.core.MySQLCoreProvider;
import pro.gravit.launchserver.auth.core.PostgresSQLCoreProvider;
import pro.gravit.launchserver.auth.core.RejectAuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.UserHardware;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupport;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportGetAllUsers;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportHardware;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportRegistration;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportHardware;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;

public abstract class AuthCoreProvider
implements AutoCloseable,
Reconfigurable {
    public static final ProviderMap<AuthCoreProvider> providers = new ProviderMap("AuthCoreProvider");
    private static final Logger logger = LogManager.getLogger();
    private static boolean registredProviders = false;

    public static void registerProviders() {
        if (!registredProviders) {
            providers.register("reject", RejectAuthCoreProvider.class);
            providers.register("mysql", MySQLCoreProvider.class);
            providers.register("postgresql", PostgresSQLCoreProvider.class);
            providers.register("memory", MemoryAuthCoreProvider.class);
            providers.register("http", HttpAuthCoreProvider.class);
            registredProviders = true;
        }
    }

    public abstract User getUserByUsername(String var1);

    public User getUserByLogin(String login) {
        return this.getUserByUsername(login);
    }

    public abstract User getUserByUUID(UUID var1);

    public abstract UserSession getUserSessionByOAuthAccessToken(String var1) throws OAuthAccessTokenExpired;

    public abstract AuthManager.AuthReport refreshAccessToken(String var1, AuthResponse.AuthContext var2);

    public void verifyAuth(AuthResponse.AuthContext context) throws AuthException {
    }

    public abstract AuthManager.AuthReport authorize(String var1, AuthResponse.AuthContext var2, AuthRequest.AuthPasswordInterface var3, boolean var4) throws IOException;

    public AuthManager.AuthReport authorize(User user, AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password, boolean minecraftAccess) throws IOException {
        return this.authorize(user.getUsername(), context, password, minecraftAccess);
    }

    public abstract void init(LaunchServer var1);

    protected boolean updateServerID(User user, String serverID) throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getDetails(Client client) {
        return List.of(new AuthPasswordDetails());
    }

    @Override
    public Map<String, Command> getCommands() {
        Map<String, Command> map = this.defaultCommandsMap();
        map.put("auth", (Command)new SubCommand("[login] (json/plain password data)", "Test auth"){

            public void invoke(String ... args) throws Exception {
                AuthManager.AuthReport report;
                this.verifyArgs(args, 1);
                Object password = null;
                if (args.length > 1) {
                    password = args[1].startsWith("{") ? (AuthRequest.AuthPasswordInterface)Launcher.gsonManager.gson.fromJson(args[1], AuthRequest.AuthPasswordInterface.class) : new AuthPlainPassword(args[1]);
                }
                if ((report = AuthCoreProvider.this.authorize(args[0], null, (AuthRequest.AuthPasswordInterface)password, false)).isUsingOAuth()) {
                    logger.info("OAuth: AccessToken: {} RefreshToken: {} MinecraftAccessToken: {}", (Object)report.oauthAccessToken(), (Object)report.oauthRefreshToken(), (Object)report.minecraftAccessToken());
                    if (report.session() != null) {
                        logger.info("UserSession: id {} expire {} user {}", (Object)report.session().getID(), (Object)report.session().getExpireIn(), (Object)(report.session().getUser() == null ? "null" : "found"));
                        logger.info(report.session().toString());
                    }
                } else {
                    logger.info("Basic: MinecraftAccessToken: {}", (Object)report.minecraftAccessToken());
                }
            }
        });
        map.put("getuserbyusername", (Command)new SubCommand("[username]", "get user by username"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                User user = AuthCoreProvider.this.getUserByUsername(args[0]);
                if (user == null) {
                    logger.info("User {} not found", (Object)args[0]);
                } else {
                    logger.info("User {}: {}", (Object)args[0], (Object)user.toString());
                }
            }
        });
        map.put("getuserbyuuid", (Command)new SubCommand("[uuid]", "get user by uuid"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                User user = AuthCoreProvider.this.getUserByUUID(UUID.fromString(args[0]));
                if (user == null) {
                    logger.info("User {} not found", (Object)args[0]);
                } else {
                    logger.info("User {}: {}", (Object)args[0], (Object)user.toString());
                }
            }
        });
        AuthSupport instance = this.isSupport(AuthSupportGetAllUsers.class);
        if (instance != null) {
            map.put("getallusers", (Command)new SubCommand("(limit)", "print all users information", (AuthSupportGetAllUsers)instance){
                final /* synthetic */ AuthSupportGetAllUsers val$instance;
                {
                    this.val$instance = authSupportGetAllUsers;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    int max = Integer.MAX_VALUE;
                    if (args.length > 0) {
                        max = Integer.parseInt(args[0]);
                    }
                    Iterable<User> users = this.val$instance.getAllUsers();
                    int counter = 0;
                    for (User u : users) {
                        logger.info("User {}", (Object)u.toString());
                        if (++counter != max) continue;
                        break;
                    }
                    logger.info("Found {} users", (Object)counter);
                }
            });
        }
        if ((instance = this.isSupport(AuthSupportHardware.class)) != null) {
            map.put("gethardwarebyid", (Command)new SubCommand("[id]", "get hardware by id", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 1);
                    UserHardware hardware = this.val$instance.getHardwareInfoById(args[0]);
                    if (hardware == null) {
                        logger.info("UserHardware {} not found", (Object)args[0]);
                    } else {
                        logger.info("UserHardware: {}", (Object)hardware);
                    }
                }
            });
            map.put("gethardwarebydata", (Command)new SubCommand("[json data]", "fulltext search hardware by json data(slow)", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 1);
                    UserHardware hardware = this.val$instance.getHardwareInfoByData((HardwareReportRequest.HardwareInfo)Launcher.gsonManager.gson.fromJson(args[0], HardwareReportRequest.HardwareInfo.class));
                    if (hardware == null) {
                        logger.info("UserHardware {} not found", (Object)args[0]);
                    } else {
                        logger.info("UserHardware: {}", (Object)hardware);
                    }
                }
            });
            map.put("getuserhardware", (Command)new SubCommand("[username]", "get hardware by username", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    UserSupportHardware hardware;
                    this.verifyArgs(args, 1);
                    User user = AuthCoreProvider.this.getUserByUUID(UUID.fromString(args[0]));
                    if (user == null) {
                        logger.info("User {} not found", (Object)args[0]);
                    }
                    if ((hardware = this.val$instance.fetchUserHardware(user)) == null) {
                        logger.error("Method fetchUserHardware return null");
                        return;
                    }
                    UserHardware userHardware = hardware.getHardware();
                    if (userHardware == null) {
                        logger.info("User {} not contains hardware info", (Object)args[0]);
                    } else {
                        logger.info("UserHardware: {}", (Object)userHardware);
                        logger.info("HardwareInfo(JSON): {}", (Object)Launcher.gsonManager.gson.toJson((Object)userHardware.getHardwareInfo()));
                    }
                }
            });
            map.put("findmulti", (Command)new SubCommand("[hardware id]", "get all users in one hardware id", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 1);
                    UserHardware hardware = this.val$instance.getHardwareInfoById(args[0]);
                    if (hardware == null) {
                        logger.info("UserHardware {} not found", (Object)args[0]);
                        return;
                    }
                    Iterable<User> users = this.val$instance.getUsersByHardwareInfo(hardware);
                    for (User user : users) {
                        logger.info("User {}", (Object)user);
                    }
                }
            });
            map.put("banhardware", (Command)new SubCommand("[hardware id]", "ban hardware by id", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 1);
                    UserHardware hardware = this.val$instance.getHardwareInfoById(args[0]);
                    if (hardware == null) {
                        logger.info("UserHardware {} not found", (Object)args[0]);
                        return;
                    }
                    this.val$instance.banHardware(hardware);
                    logger.info("UserHardware {} banned", (Object)args[0]);
                }
            });
            map.put("unbanhardware", (Command)new SubCommand("[hardware id]", "ban hardware by id", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 1);
                    UserHardware hardware = this.val$instance.getHardwareInfoById(args[0]);
                    if (hardware == null) {
                        logger.info("UserHardware {} not found", (Object)args[0]);
                        return;
                    }
                    this.val$instance.unbanHardware(hardware);
                    logger.info("UserHardware {} unbanned", (Object)args[0]);
                }
            });
            map.put("comparehardware", (Command)new SubCommand("[json data 1] [json data 2]", "compare hardware info", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 2);
                    HardwareReportRequest.HardwareInfo hardware1 = (HardwareReportRequest.HardwareInfo)Launcher.gsonManager.gson.fromJson(args[0], HardwareReportRequest.HardwareInfo.class);
                    HardwareReportRequest.HardwareInfo hardware2 = (HardwareReportRequest.HardwareInfo)Launcher.gsonManager.gson.fromJson(args[1], HardwareReportRequest.HardwareInfo.class);
                    AuthSupportHardware.HardwareInfoCompareResult result = this.val$instance.compareHardwareInfo(hardware1, hardware2);
                    if (result == null) {
                        logger.error("Method compareHardwareInfo return null");
                        return;
                    }
                    logger.info("Compare result: {} Spoof: {} first {} second", (Object)result.compareLevel, (Object)result.firstSpoofingLevel, (Object)result.secondSpoofingLevel);
                }
            });
        }
        if ((instance = this.isSupport(AuthSupportRegistration.class)) != null) {
            map.put("register", (Command)new SubCommand("[username] [email] [plain or json password] (json args)", "Register new user", (AuthSupportRegistration)instance){
                final /* synthetic */ AuthSupportRegistration val$instance;
                {
                    this.val$instance = authSupportRegistration;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 2);
                    Map map = null;
                    String username = args[0];
                    String email = args[1];
                    String plainPassword = args[2];
                    if (args.length > 3) {
                        Type typeOfMap = new TypeToken<Map<String, String>>(){}.getType();
                        map = (Map)Launcher.gsonManager.gson.fromJson(args[2], typeOfMap);
                    }
                    Object password = plainPassword.startsWith("{") ? (AuthRequest.AuthPasswordInterface)Launcher.gsonManager.gson.fromJson(plainPassword, AuthRequest.AuthPasswordInterface.class) : new AuthPlainPassword(plainPassword);
                    User user = this.val$instance.registration(username, email, (AuthRequest.AuthPasswordInterface)password, map);
                    logger.info("User '{}' registered", (Object)user.toString());
                }
            });
        }
        return map;
    }

    public User checkServer(Client client, String username, String serverID) throws IOException {
        User user = this.getUserByUsername(username);
        if (user == null) {
            return null;
        }
        if (user.getUsername().equals(username) && user.getServerId().equals(serverID)) {
            return user;
        }
        return null;
    }

    public boolean joinServer(Client client, String username, String accessToken, String serverID) throws IOException {
        User user = client.getUser();
        if (user == null) {
            return false;
        }
        return user.getUsername().equals(username) && user.getAccessToken().equals(accessToken) && this.updateServerID(user, serverID);
    }

    public <T> T isSupport(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public abstract void close() throws IOException;

    public static class OAuthAccessTokenExpired
    extends Exception {
        public OAuthAccessTokenExpired() {
        }

        public OAuthAccessTokenExpired(String message) {
            super(message);
        }

        public OAuthAccessTokenExpired(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class PasswordVerifyReport {
        public static final PasswordVerifyReport REQUIRED_2FA = new PasswordVerifyReport(-1);
        public static final PasswordVerifyReport FAILED = new PasswordVerifyReport(false);
        public static final PasswordVerifyReport OK = new PasswordVerifyReport(true);
        public final boolean success;
        public final boolean needMoreFactors;
        public final List<Integer> factors;

        public PasswordVerifyReport(boolean success) {
            this.success = success;
            this.needMoreFactors = false;
            this.factors = List.of();
        }

        public PasswordVerifyReport(AuthManager.AuthReport report) {
            this.success = true;
            this.needMoreFactors = false;
            this.factors = List.of();
        }

        public PasswordVerifyReport(int nextFactor) {
            this.success = false;
            this.needMoreFactors = true;
            this.factors = List.of(Integer.valueOf(nextFactor));
        }

        public PasswordVerifyReport(List<Integer> factors) {
            this.success = false;
            this.needMoreFactors = false;
            this.factors = Collections.unmodifiableList(factors);
        }

        private PasswordVerifyReport(boolean success, boolean needMoreFactors, List<Integer> factors) {
            this.success = success;
            this.needMoreFactors = needMoreFactors;
            this.factors = factors;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

