/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.texture;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.HTTPRequest;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launchserver.auth.texture.RequestTextureProvider;
import pro.gravit.launchserver.auth.texture.TextureProvider;

public class JsonTextureProvider
extends TextureProvider {
    public String url;
    private final transient Logger logger = LogManager.getLogger();
    private static final transient Type MAP_TYPE = new TypeToken<Map<String, Texture>>(){}.getType();

    @Override
    public void close() throws IOException {
    }

    @Override
    public Texture getCloakTexture(UUID uuid, String username, String client) throws IOException {
        this.logger.warn("Ineffective get cloak texture for {}", (Object)username);
        return this.getAssets(uuid, username, client).get("CAPE");
    }

    @Override
    public Texture getSkinTexture(UUID uuid, String username, String client) throws IOException {
        this.logger.warn("Ineffective get skin texture for {}", (Object)username);
        return this.getAssets(uuid, username, client).get("SKIN");
    }

    @Override
    public Map<String, Texture> getAssets(UUID uuid, String username, String client) {
        try {
            JsonElement result = HTTPRequest.jsonRequest(null, (String)"GET", (URL)new URL(RequestTextureProvider.getTextureURL(this.url, uuid, username, client)));
            Map map = (Map)Launcher.gsonManager.gson.fromJson(result, MAP_TYPE);
            if (map == null) {
                return new HashMap<String, Texture>();
            }
            if (map.get("skin") != null) {
                map.put("SKIN", (Texture)map.get("skin"));
                map.remove("skin");
            }
            if (map.get("cloak") != null) {
                map.put("CAPE", (Texture)map.get("cloak"));
                map.remove("cloak");
            }
            return map;
        }
        catch (IOException e) {
            this.logger.error("JsonTextureProvider", (Throwable)e);
            return new HashMap<String, Texture>();
        }
    }
}

