/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.helper.IOHelper;

public final class DownloadAssetCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public DownloadAssetCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[version] [dir]";
    }

    public String getUsageDescription() {
        return "Download asset dir";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 2);
        String versionName = args[0];
        String dirName = IOHelper.verifyFileName((String)args[1]);
        Path assetDir = this.server.updatesDir.resolve(dirName);
        this.logger.info("Creating asset dir: '{}'", (Object)dirName);
        Files.createDirectory(assetDir, new FileAttribute[0]);
        this.logger.info("Downloading asset, it may take some time");
        this.server.mirrorManager.downloadZip(assetDir, "assets/%s.zip", versionName);
        this.server.syncUpdatesDir(Collections.singleton(dirName));
        this.logger.info("Asset successfully downloaded: '{}'", (Object)dirName);
    }
}

