/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.handlers;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launchserver.socket.NettyConnectContext;
import pro.gravit.utils.helper.IOHelper;

public class NettyWebAPIHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final TreeSet<SeverletPathPair> severletList = new TreeSet<SeverletPathPair>(Comparator.comparingInt(e -> -e.key.length()));
    private static final DefaultFullHttpResponse ERROR_500 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])IOHelper.encode((String)"Internal Server Error 500")));
    private final NettyConnectContext context;
    private final transient Logger logger = LogManager.getLogger();

    public NettyWebAPIHandler(NettyConnectContext context) {
        this.context = context;
    }

    public static SeverletPathPair addNewSeverlet(String path, SimpleSeverletHandler callback) {
        SeverletPathPair pair = new SeverletPathPair("/webapi/".concat(path), callback);
        severletList.add(pair);
        return pair;
    }

    public static SeverletPathPair addUnsafeSeverlet(String path, SimpleSeverletHandler callback) {
        SeverletPathPair pair = new SeverletPathPair(path, callback);
        severletList.add(pair);
        return pair;
    }

    public static void removeSeverlet(SeverletPathPair pair) {
        severletList.remove(pair);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        boolean isNext = true;
        for (SeverletPathPair pair : severletList) {
            if (!msg.uri().startsWith(pair.key)) continue;
            try {
                pair.callback.handle(ctx, msg, this.context);
            }
            catch (Throwable e) {
                this.logger.error("WebAPI Error", e);
                ctx.writeAndFlush((Object)ERROR_500, ctx.voidPromise());
            }
            isNext = false;
            break;
        }
        if (isNext) {
            msg.retain();
            ctx.fireChannelRead((Object)msg);
        }
    }

    static {
        ERROR_500.retain();
    }

    public static class SeverletPathPair {
        public final String key;
        public final SimpleSeverletHandler callback;

        public SeverletPathPair(String key, SimpleSeverletHandler callback) {
            this.key = key;
            this.callback = callback;
        }
    }

    @FunctionalInterface
    public static interface SimpleSeverletHandler {
        public void handle(ChannelHandlerContext var1, FullHttpRequest var2, NettyConnectContext var3) throws Exception;

        default public Map<String, String> getParamsFromUri(String uri) {
            int ind = uri.indexOf("?");
            if (ind <= 0) {
                return Map.of();
            }
            String sub = uri.substring(ind + 1);
            String[] result = sub.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : result) {
                String c = URLDecoder.decode(s, StandardCharsets.UTF_8);
                int index = c.indexOf("=");
                if (index <= 0) continue;
                String key = c.substring(0, index);
                String value = c.substring(index + 1);
                map.put(key, value);
            }
            return map;
        }

        default public FullHttpResponse simpleResponse(HttpResponseStatus status, String body) {
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, body != null ? Unpooled.wrappedBuffer((byte[])IOHelper.encode((String)body)) : Unpooled.buffer());
        }

        default public FullHttpResponse simpleJsonResponse(HttpResponseStatus status, Object body) {
            DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, body != null ? Unpooled.wrappedBuffer((byte[])IOHelper.encode((String)Launcher.gsonManager.gson.toJson(body))) : Unpooled.buffer());
            httpResponse.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
            return httpResponse;
        }

        default public void sendHttpResponse(ChannelHandlerContext ctx, FullHttpResponse response) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

