/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.UUID;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.AdditionalDataRequestEvent;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportAdditionalData;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;

public class AdditionalDataResponse
extends SimpleResponse {
    public String username;
    public UUID uuid;

    @Override
    public String getType() {
        return "additionalData";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) throws Exception {
        if (!client.isAuth) {
            this.sendError("Access denied");
            return;
        }
        AuthProviderPair pair = client.auth;
        if (this.username == null && this.uuid == null) {
            Map<Object, Object> properties;
            User user = client.getUser();
            if (user instanceof UserSupportAdditionalData) {
                UserSupportAdditionalData userSupport = (UserSupportAdditionalData)((Object)user);
                properties = client.permissions.hasPerm("launchserver.request.addionaldata.privileged") ? userSupport.getPropertiesMap() : userSupport.getPropertiesMapUnprivilegedSelf();
            } else {
                properties = Map.of();
            }
            this.sendResult((RequestEvent)new AdditionalDataRequestEvent(properties));
            return;
        }
        User user = this.username != null ? pair.core.getUserByUsername(this.username) : pair.core.getUserByUUID(this.uuid);
        if (!(user instanceof UserSupportAdditionalData)) {
            this.sendResult((RequestEvent)new AdditionalDataRequestEvent(Map.of()));
            return;
        }
        UserSupportAdditionalData userSupport = (UserSupportAdditionalData)((Object)user);
        Map<String, String> properties = client.permissions.hasPerm("launchserver.request.addionaldata.privileged") ? userSupport.getPropertiesMap() : userSupport.getPropertiesMapUnprivileged();
        this.sendResult((RequestEvent)new AdditionalDataRequestEvent(properties));
    }
}

