/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.LaunchServerBuilder;
import pro.gravit.launchserver.StarterAgent;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.password.PasswordVerifier;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.texture.TextureProvider;
import pro.gravit.launchserver.components.Component;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.config.LaunchServerRuntimeConfig;
import pro.gravit.launchserver.manangers.CertificateManager;
import pro.gravit.launchserver.manangers.LaunchServerGsonManager;
import pro.gravit.launchserver.modules.impl.LaunchServerModulesManager;
import pro.gravit.launchserver.socket.WebSocketService;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.command.JLineCommandHandler;
import pro.gravit.utils.command.StdCommandHandler;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class LaunchServerStarter {
    public static final boolean allowUnsigned = Boolean.getBoolean("launchserver.allowUnsigned");
    public static final boolean prepareMode = Boolean.getBoolean("launchserver.prepareMode");
    private static final Logger logger = LogManager.getLogger();

    public static void main(String[] args) throws Exception {
        LaunchServerRuntimeConfig runtimeConfig;
        LaunchServerConfig config;
        JLineCommandHandler localCommandHandler;
        JVMHelper.checkStackTrace(LaunchServerStarter.class);
        JVMHelper.verifySystemProperties(LaunchServer.class, (boolean)true);
        LogHelper.printVersion((String)"LaunchServer");
        LogHelper.printLicense((String)"LaunchServer");
        if (!StarterAgent.isAgentStarted()) {
            LogHelper.error((String)"StarterAgent is not started!");
            LogHelper.error((String)"You should add to JVM options this option: `-javaagent:LaunchServer.jar`");
        }
        Path dir = IOHelper.WORKING_DIR;
        try {
            Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (ClassNotFoundException ex) {
            LogHelper.error((String)"Library BouncyCastle not found! Is directory 'libraries' empty?");
            return;
        }
        CertificateManager certificateManager = new CertificateManager();
        try {
            certificateManager.readTrustStore(dir.resolve("truststore"));
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
        LauncherTrustManager.CheckClassResult result = certificateManager.checkClass(LaunchServer.class);
        if (result.type == LauncherTrustManager.CheckClassResultType.SUCCESS) {
            logger.info("LaunchServer signed by {}", (Object)result.endCertificate.getSubjectX500Principal().getName());
        } else if (result.type != LauncherTrustManager.CheckClassResultType.NOT_SIGNED) {
            if (result.exception != null) {
                logger.error((Object)result.exception);
            }
            logger.warn("LaunchServer signed incorrectly. Status: {}", (Object)result.type.name());
        }
        LaunchServer.LaunchServerEnv env = LaunchServer.LaunchServerEnv.PRODUCTION;
        LaunchServerModulesManager modulesManager = new LaunchServerModulesManager(dir.resolve("modules"), dir.resolve("config"), certificateManager.trustManager);
        modulesManager.autoload();
        modulesManager.initModules(null);
        LaunchServerStarter.registerAll();
        LaunchServerStarter.initGson(modulesManager);
        final Path configFile = IOHelper.exists((Path)dir.resolve("LaunchServer.conf")) ? dir.resolve("LaunchServer.conf") : dir.resolve("LaunchServer.json");
        final Path runtimeConfigFile = IOHelper.exists((Path)dir.resolve("RuntimeLaunchServer.conf")) ? dir.resolve("RuntimeLaunchServer.conf") : dir.resolve("RuntimeLaunchServer.json");
        try {
            Class.forName("org.jline.terminal.Terminal");
            localCommandHandler = new JLineCommandHandler();
            logger.info("JLine2 terminal enabled");
        }
        catch (ClassNotFoundException ignored) {
            localCommandHandler = new StdCommandHandler(true);
            logger.warn("JLine2 isn't in classpath, using std");
        }
        modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        LaunchServerStarter.generateConfigIfNotExists(configFile, (CommandHandler)localCommandHandler, env);
        logger.info("Reading LaunchServer config file");
        try (BufferedReader reader = IOHelper.newReader((Path)configFile);){
            config = (LaunchServerConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerConfig.class);
        }
        if (!Files.exists(runtimeConfigFile, new LinkOption[0])) {
            logger.info("Reset LaunchServer runtime config file");
            runtimeConfig = new LaunchServerRuntimeConfig();
            runtimeConfig.reset();
        } else {
            logger.info("Reading LaunchServer runtime config file");
            reader = IOHelper.newReader((Path)runtimeConfigFile);
            try {
                runtimeConfig = (LaunchServerRuntimeConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerRuntimeConfig.class);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        LaunchServer.LaunchServerConfigManager launchServerConfigManager = new LaunchServer.LaunchServerConfigManager(){

            @Override
            public LaunchServerConfig readConfig() throws IOException {
                LaunchServerConfig config1;
                try (BufferedReader reader = IOHelper.newReader((Path)configFile);){
                    config1 = (LaunchServerConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerConfig.class);
                }
                return config1;
            }

            @Override
            public LaunchServerRuntimeConfig readRuntimeConfig() throws IOException {
                LaunchServerRuntimeConfig config1;
                try (BufferedReader reader = IOHelper.newReader((Path)runtimeConfigFile);){
                    config1 = (LaunchServerRuntimeConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerRuntimeConfig.class);
                }
                return config1;
            }

            @Override
            public void writeConfig(LaunchServerConfig config) throws IOException {
                try (BufferedWriter writer = IOHelper.newWriter((Path)configFile);){
                    if (Launcher.gsonManager.configGson != null) {
                        Launcher.gsonManager.configGson.toJson((Object)config, (Appendable)writer);
                    } else {
                        logger.error("Error writing LaunchServer runtime config file. Gson is null");
                    }
                }
            }

            @Override
            public void writeRuntimeConfig(LaunchServerRuntimeConfig config) throws IOException {
                try (BufferedWriter writer = IOHelper.newWriter((Path)runtimeConfigFile);){
                    if (Launcher.gsonManager.configGson != null) {
                        Launcher.gsonManager.configGson.toJson((Object)config, (Appendable)writer);
                    } else {
                        logger.error("Error writing LaunchServer runtime config file. Gson is null");
                    }
                }
            }
        };
        LaunchServer.LaunchServerDirectories directories = new LaunchServer.LaunchServerDirectories();
        directories.dir = dir;
        LaunchServer server = new LaunchServerBuilder().setDirectories(directories).setEnv(env).setCommandHandler((CommandHandler)localCommandHandler).setRuntimeConfig(runtimeConfig).setConfig(config).setModulesManager(modulesManager).setLaunchServerConfigManager(launchServerConfigManager).setCertificateManager(certificateManager).build();
        if (!prepareMode) {
            server.run();
        } else {
            server.close();
        }
    }

    public static void initGson(LaunchServerModulesManager modulesManager) {
        Launcher.gsonManager = new LaunchServerGsonManager(modulesManager);
        Launcher.gsonManager.initGson();
    }

    public static void registerAll() {
        AuthCoreProvider.registerProviders();
        PasswordVerifier.registerProviders();
        TextureProvider.registerProviders();
        Component.registerComponents();
        ProtectHandler.registerHandlers();
        WebSocketService.registerResponses();
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
    }

    public static void generateConfigIfNotExists(Path configFile, CommandHandler commandHandler, LaunchServer.LaunchServerEnv env) throws IOException {
        String address;
        if (IOHelper.isFile((Path)configFile)) {
            return;
        }
        logger.info("Creating LaunchServer config");
        LaunchServerConfig newConfig = LaunchServerConfig.getDefault(env);
        if (env.equals((Object)LaunchServer.LaunchServerEnv.TEST)) {
            address = "localhost";
            newConfig.setProjectName("test");
        } else {
            String projectName;
            address = System.getenv("ADDRESS");
            if (address == null) {
                address = System.getProperty("launchserver.address", null);
            }
            if (address == null) {
                System.out.println("LaunchServer address(default: localhost): ");
                address = commandHandler.readLine();
            }
            if ((projectName = System.getenv("PROJECTNAME")) == null) {
                projectName = System.getProperty("launchserver.projectname", null);
            }
            if (projectName == null) {
                System.out.println("LaunchServer projectName: ");
                projectName = commandHandler.readLine();
            }
            newConfig.setProjectName(projectName);
        }
        if (address == null || address.isEmpty()) {
            logger.error("Address null. Using localhost");
            address = "localhost";
        }
        if (newConfig.projectName == null || newConfig.projectName.isEmpty()) {
            logger.error("ProjectName null. Using MineCraft");
            newConfig.projectName = "MineCraft";
        }
        newConfig.netty.address = "ws://" + address + ":9274/api";
        newConfig.netty.downloadURL = "http://" + address + ":9274/%dirname%/";
        newConfig.netty.launcherURL = "http://" + address + ":9274/Launcher.jar";
        newConfig.netty.launcherEXEURL = "http://" + address + ":9274/Launcher.exe";
        logger.info("Writing LaunchServer config file");
        try (BufferedWriter writer = IOHelper.newWriter((Path)configFile);){
            Launcher.gsonManager.configGson.toJson((Object)newConfig, (Appendable)writer);
        }
    }
}

