/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.LauncherBinary;
import pro.gravit.launchserver.binary.tasks.AdditionalFixesApplyTask;
import pro.gravit.launchserver.binary.tasks.AttachJarsTask;
import pro.gravit.launchserver.binary.tasks.CertificateAutogenTask;
import pro.gravit.launchserver.binary.tasks.CompressBuildTask;
import pro.gravit.launchserver.binary.tasks.MainBuildTask;
import pro.gravit.launchserver.binary.tasks.PrepareBuildTask;
import pro.gravit.launchserver.binary.tasks.SignJarTask;

public final class JARLauncherBinary
extends LauncherBinary {
    public final AtomicLong count = new AtomicLong(0L);
    public final Path runtimeDir;
    public final Path guardDir;
    public final Path buildDir;
    public final List<Path> coreLibs;
    public final List<Path> addonLibs;

    public JARLauncherBinary(LaunchServer server) throws IOException {
        super(server, JARLauncherBinary.resolve(server, ".jar"), "Launcher-%s-%d.jar");
        this.runtimeDir = server.dir.resolve("runtime");
        this.guardDir = server.dir.resolve("guard");
        this.buildDir = server.dir.resolve("build");
        this.coreLibs = new ArrayList<Path>();
        this.addonLibs = new ArrayList<Path>();
        if (!Files.isDirectory(this.buildDir, new LinkOption[0])) {
            Files.deleteIfExists(this.buildDir);
            Files.createDirectory(this.buildDir, new FileAttribute[0]);
        }
    }

    @Override
    public void init() {
        this.tasks.add(new PrepareBuildTask(this.server));
        if (!this.server.config.sign.enabled) {
            this.tasks.add(new CertificateAutogenTask(this.server));
        }
        this.tasks.add(new MainBuildTask(this.server));
        this.tasks.add(new AttachJarsTask(this.server));
        this.tasks.add(new AdditionalFixesApplyTask(this.server));
        if (this.server.config.launcher.compress) {
            this.tasks.add(new CompressBuildTask(this.server));
        }
        this.tasks.add(new SignJarTask(this.server.config.sign, this.server));
    }
}

