/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.components.Component;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.launchserver.socket.response.auth.JoinServerResponse;
import pro.gravit.utils.HookException;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;

public class WhitelistComponent
extends Component
implements AutoCloseable,
Reconfigurable {
    private final transient Logger logger = LogManager.getLogger();
    public String message = "auth.message.techwork";
    public boolean enabled = true;
    public List<String> whitelist = new ArrayList<String>();
    private transient LaunchServer server;

    @Override
    public void init(LaunchServer launchServer) {
        this.server = launchServer;
        this.server.authHookManager.preHook.registerHook(this::hookAuth);
        this.server.authHookManager.joinServerHook.registerHook(this::hookJoin);
    }

    public boolean hookAuth(AuthResponse.AuthContext context, Client client) throws HookException {
        if (this.enabled && !this.whitelist.contains(context.login)) {
            throw new HookException(this.message);
        }
        return false;
    }

    public boolean hookJoin(JoinServerResponse response, Client client) throws HookException {
        if (this.enabled && !this.whitelist.contains(response.username)) {
            throw new HookException(this.message);
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        this.server.authHookManager.preHook.unregisterHook(this::hookAuth);
        this.server.authHookManager.joinServerHook.unregisterHook(this::hookJoin);
    }

    @Override
    public Map<String, Command> getCommands() {
        Map<String, Command> commands = this.defaultCommandsMap();
        commands.put("setmessage", (Command)new SubCommand("[new message]", "set message"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                WhitelistComponent.this.message = args[0];
                WhitelistComponent.this.logger.info("Message: {}", (Object)args[0]);
            }
        });
        commands.put("whitelist.add", (Command)new SubCommand("[login]", "add login to whitelist"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                WhitelistComponent.this.whitelist.add(args[0]);
                WhitelistComponent.this.logger.info("{} added to whitelist", (Object)args[0]);
            }
        });
        commands.put("whitelist.remove", (Command)new SubCommand("[login]", "remove login from whitelist"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                WhitelistComponent.this.whitelist.remove(args[0]);
                WhitelistComponent.this.logger.info("{} removed from whitelist", (Object)args[0]);
            }
        });
        commands.put("disable", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                WhitelistComponent.this.enabled = false;
                WhitelistComponent.this.logger.info("Whitelist disabled");
            }
        });
        commands.put("enable", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                WhitelistComponent.this.enabled = true;
                WhitelistComponent.this.logger.info("Whitelist enabled");
            }
        });
        return commands;
    }
}

