/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import java.util.HashMap;
import java.util.Map;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.command.basic.HelpCommand;
import pro.gravit.utils.helper.VerifyHelper;

public class ReconfigurableManager {
    private final HashMap<String, Command> RECONFIGURABLE = new HashMap();

    public void registerReconfigurable(String name, Reconfigurable reconfigurable) {
        VerifyHelper.putIfAbsent(this.RECONFIGURABLE, (Object)name.toLowerCase(), (Object)((Object)new ReconfigurableVirtualCommand(reconfigurable.getCommands())), (String)String.format("Reconfigurable has been already registered: '%s'", name));
    }

    public void unregisterReconfigurable(String name) {
        this.RECONFIGURABLE.remove(name.toLowerCase());
    }

    public void call(String name, String action, String[] args) throws Exception {
        Command commands = this.RECONFIGURABLE.get(name);
        if (commands == null) {
            throw new CommandException(String.format("Reconfigurable %s not found", name));
        }
        Command command = (Command)commands.childCommands.get(action);
        if (command == null) {
            throw new CommandException(String.format("Action %s.%s not found", name, action));
        }
        command.invoke(args);
    }

    public void printHelp(String name) throws CommandException {
        Command commands = this.RECONFIGURABLE.get(name);
        if (commands == null) {
            throw new CommandException(String.format("Reconfigurable %s not found", name));
        }
        HelpCommand.printSubCommandsHelp((String)name, (Command)commands);
    }

    public Map<String, Command> getCommands() {
        return this.RECONFIGURABLE;
    }

    private static class ReconfigurableVirtualCommand
    extends Command {
        public ReconfigurableVirtualCommand(Map<String, Command> childs) {
            super(childs);
        }

        public String getArgsDescription() {
            return null;
        }

        public String getUsageDescription() {
            return null;
        }

        public void invoke(String ... args) throws Exception {
            this.invokeSubcommands(args);
        }
    }
}

