/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.Feature;
import pro.gravit.launchserver.auth.Features;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.AuthSocialProvider;
import pro.gravit.launchserver.auth.handler.AuthHandler;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.texture.TextureProvider;

public final class AuthProviderPair {
    public boolean isDefault = true;
    public AuthCoreProvider core;
    public AuthSocialProvider social;
    public AuthProvider provider;
    public AuthHandler handler;
    public TextureProvider textureProvider;
    public Map<String, String> links;
    public transient String name;
    public transient Set<String> features;
    public String displayName;

    public AuthProviderPair(AuthProvider provider, AuthHandler handler, TextureProvider textureProvider) {
        this.provider = provider;
        this.handler = handler;
        this.textureProvider = textureProvider;
    }

    public AuthProviderPair(AuthCoreProvider core, TextureProvider textureProvider) {
        this.core = core;
        this.textureProvider = textureProvider;
    }

    public AuthProviderPair(AuthCoreProvider core, AuthSocialProvider social) {
        this.core = core;
        this.social = social;
    }

    public AuthProviderPair(AuthCoreProvider core, AuthSocialProvider social, TextureProvider textureProvider) {
        this.core = core;
        this.social = social;
        this.textureProvider = textureProvider;
    }

    public static Set<String> getFeatures(Class<?> clazz) {
        HashSet<String> list = new HashSet<String>();
        AuthProviderPair.getFeatures(clazz, list);
        return list;
    }

    public static void getFeatures(Class<?> clazz, Set<String> list) {
        Class<?>[] interfaces;
        Class<?> superClass;
        Features features = clazz.getAnnotation(Features.class);
        if (features != null) {
            for (Feature feature : features.value()) {
                list.add(feature.value());
            }
        }
        if ((superClass = clazz.getSuperclass()) != null && superClass != Object.class) {
            AuthProviderPair.getFeatures(superClass, list);
        }
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            AuthProviderPair.getFeatures(i, list);
        }
    }

    public final <T> T isSupport(Class<T> clazz) {
        if (this.core == null) {
            return null;
        }
        T result = null;
        if (this.social != null) {
            result = this.social.isSupport(clazz);
        }
        if (result == null) {
            result = this.core.isSupport(clazz);
        }
        return result;
    }

    public final void init(LaunchServer srv, String name) {
        this.name = name;
        if (this.links != null) {
            this.link(srv);
        }
        if (this.core == null) {
            if (this.provider == null) {
                throw new NullPointerException(String.format("Auth %s provider null", name));
            }
            if (this.handler == null) {
                throw new NullPointerException(String.format("Auth %s handler null", name));
            }
            if (this.social != null) {
                throw new IllegalArgumentException(String.format("Auth %s social can't be used in provider/handler method", name));
            }
            this.provider.init(srv);
            this.handler.init(srv);
        } else {
            if (this.provider != null) {
                throw new IllegalArgumentException(String.format("Auth %s provider not null", name));
            }
            if (this.handler != null) {
                throw new IllegalArgumentException(String.format("Auth %s handler not null", name));
            }
            this.core.init(srv);
            this.features = new HashSet<String>();
            AuthProviderPair.getFeatures(this.core.getClass(), this.features);
            if (this.social != null) {
                this.social.init(srv, this.core);
                AuthProviderPair.getFeatures(this.social.getClass(), this.features);
            }
        }
    }

    public final void link(LaunchServer srv) {
        this.links.forEach((k, v) -> {
            AuthProviderPair pair = srv.config.getAuthProviderPair((String)v);
            if (pair == null) {
                throw new NullPointerException(String.format("Auth %s link failed. Pair %s not found", this.name, v));
            }
            if ("provider".equals(k)) {
                if (pair.provider == null) {
                    throw new NullPointerException(String.format("Auth %s link failed. %s.provider is null", this.name, v));
                }
                this.provider = pair.provider;
            } else if ("handler".equals(k)) {
                if (pair.handler == null) {
                    throw new NullPointerException(String.format("Auth %s link failed. %s.handler is null", this.name, v));
                }
                this.handler = pair.handler;
            } else if ("textureProvider".equals(k)) {
                if (pair.textureProvider == null) {
                    throw new NullPointerException(String.format("Auth %s link failed. %s.textureProvider is null", this.name, v));
                }
                this.textureProvider = pair.textureProvider;
            } else if ("core".equals(k)) {
                if (pair.core == null) {
                    throw new NullPointerException(String.format("Auth %s link failed. %s.core is null", this.name, v));
                }
                this.core = pair.core;
            }
        });
    }

    public final void close() throws IOException {
        if (this.social != null) {
            this.social.close();
        }
        if (this.core == null) {
            this.provider.close();
            this.handler.close();
        } else {
            this.core.close();
        }
        if (this.textureProvider != null) {
            this.textureProvider.close();
        }
    }

    public final boolean isUseCore() {
        return this.core != null;
    }

    public final boolean isUseSocial() {
        return this.core != null && this.social != null;
    }

    public final boolean isUseProviderAndHandler() {
        return !this.isUseCore();
    }
}

