/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.details.AuthPasswordDetails;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.core.JsonCoreProvider;
import pro.gravit.launchserver.auth.core.MySQLCoreProvider;
import pro.gravit.launchserver.auth.core.RejectAuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.UserHardware;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupport;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportGetAllUsers;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportHardware;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportHardware;
import pro.gravit.launchserver.auth.protect.hwid.HWIDProvider;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.command.SubCommand;

public abstract class AuthCoreProvider
implements AutoCloseable,
Reconfigurable {
    public static final ProviderMap<AuthCoreProvider> providers = new ProviderMap("AuthCoreProvider");
    private static final Logger logger = LogManager.getLogger();
    private static boolean registredProviders = false;

    public static void registerProviders() {
        if (!registredProviders) {
            providers.register("reject", RejectAuthCoreProvider.class);
            providers.register("mysql", MySQLCoreProvider.class);
            providers.register("json", JsonCoreProvider.class);
            registredProviders = true;
        }
    }

    public abstract User getUserByUsername(String var1);

    public User getUserByLogin(String login) {
        return this.getUserByUsername(login);
    }

    public abstract User getUserByUUID(UUID var1);

    public abstract UserSession getUserSessionByOAuthAccessToken(String var1) throws OAuthAccessTokenExpired;

    public abstract AuthManager.AuthReport refreshAccessToken(String var1, AuthResponse.AuthContext var2);

    public abstract void verifyAuth(AuthResponse.AuthContext var1) throws AuthException;

    public abstract PasswordVerifyReport verifyPassword(User var1, AuthRequest.AuthPasswordInterface var2);

    public abstract AuthManager.AuthReport createOAuthSession(User var1, AuthResponse.AuthContext var2, PasswordVerifyReport var3, boolean var4) throws IOException;

    public abstract void init(LaunchServer var1);

    protected abstract boolean updateServerID(User var1, String var2) throws IOException;

    public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getDetails(Client client) {
        return List.of(new AuthPasswordDetails());
    }

    @Override
    public Map<String, Command> getCommands() {
        Map<String, Command> map = this.defaultCommandsMap();
        map.put("checkpassword", (Command)new SubCommand("[username] [json/plain password data]", "check password"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 2);
                User user = AuthCoreProvider.this.getUserByUsername(args[0]);
                if (user == null) {
                    throw new CommandException("User not found");
                }
                Object password = args[1].startsWith("{") ? (AuthRequest.AuthPasswordInterface)Launcher.gsonManager.gson.fromJson(args[1], AuthRequest.AuthPasswordInterface.class) : new AuthPlainPassword(args[1]);
                PasswordVerifyReport report = AuthCoreProvider.this.verifyPassword(user, (AuthRequest.AuthPasswordInterface)password);
                if (report.success) {
                    logger.info("Password correct");
                } else if (report.needMoreFactor) {
                    if (report.factors.size() == 1 && report.factors.get(0) == -1) {
                        logger.info("Password not correct: Required 2FA");
                    } else {
                        logger.info("Password not correct: Required more factors: {}", (Object)report.factors.toString());
                    }
                } else {
                    logger.info("Password incorrect");
                }
            }
        });
        map.put("getuserbyusername", (Command)new SubCommand("[username]", "get user by username"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                User user = AuthCoreProvider.this.getUserByUsername(args[0]);
                if (user == null) {
                    logger.info("User {} not found", (Object)args[0]);
                } else {
                    logger.info("User {}: {}", (Object)args[0], (Object)user.toString());
                }
            }
        });
        map.put("getuserbyuuid", (Command)new SubCommand("[uuid]", "get user by uuid"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                User user = AuthCoreProvider.this.getUserByUUID(UUID.fromString(args[0]));
                if (user == null) {
                    logger.info("User {} not found", (Object)args[0]);
                } else {
                    logger.info("User {}: {}", (Object)args[0], (Object)user.toString());
                }
            }
        });
        map.put("createsession", (Command)new SubCommand("[username] (true/false)", "create user session with/without minecraft access"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                User user = AuthCoreProvider.this.getUserByUsername(args[0]);
                if (user == null) {
                    logger.info("User {} not found", (Object)args[0]);
                    return;
                }
                boolean minecraftAccess = args.length > 1 && Boolean.parseBoolean(args[1]);
                AuthManager.AuthReport report = AuthCoreProvider.this.createOAuthSession(user, null, null, minecraftAccess);
                if (report == null) {
                    logger.error("Method createOAuthSession return null");
                    return;
                }
                if (report.isUsingOAuth()) {
                    logger.info("OAuth: AccessToken: {} RefreshToken: {} MinecraftAccessToken: {}", (Object)report.oauthAccessToken, (Object)report.oauthRefreshToken, (Object)report.minecraftAccessToken);
                    if (report.session != null) {
                        logger.info("UserSession: id {} expire {} user {}", (Object)report.session.getID(), (Object)report.session.getExpireIn(), (Object)(report.session.getUser() == null ? "null" : "found"));
                        logger.info(report.session.toString());
                    }
                } else {
                    logger.info("Basic: MinecraftAccessToken: {}", (Object)report.minecraftAccessToken);
                }
            }
        });
        AuthSupport instance = this.isSupport(AuthSupportGetAllUsers.class);
        if (instance != null) {
            map.put("getallusers", (Command)new SubCommand("(limit)", "print all users information", (AuthSupportGetAllUsers)instance){
                final /* synthetic */ AuthSupportGetAllUsers val$instance;
                {
                    this.val$instance = authSupportGetAllUsers;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    int max = Integer.MAX_VALUE;
                    if (args.length > 0) {
                        max = Integer.parseInt(args[0]);
                    }
                    Iterable<User> users = this.val$instance.getAllUsers();
                    int counter = 0;
                    for (User u : users) {
                        logger.info("User {}", (Object)u.toString());
                        if (++counter != max) continue;
                        break;
                    }
                    logger.info("Found {} users", (Object)counter);
                }
            });
        }
        if ((instance = this.isSupport(AuthSupportHardware.class)) != null) {
            map.put("gethardwarebyid", (Command)new SubCommand("[id]", "get hardware by id", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 1);
                    UserHardware hardware = this.val$instance.getHardwareInfoById(args[0]);
                    if (hardware == null) {
                        logger.info("UserHardware {} not found", (Object)args[0]);
                    } else {
                        logger.info("UserHardware: {}", (Object)hardware);
                    }
                }
            });
            map.put("gethardwarebydata", (Command)new SubCommand("[json data]", "fulltext search hardware by json data(slow)", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 1);
                    UserHardware hardware = this.val$instance.getHardwareInfoByData((HardwareReportRequest.HardwareInfo)Launcher.gsonManager.gson.fromJson(args[0], HardwareReportRequest.HardwareInfo.class));
                    if (hardware == null) {
                        logger.info("UserHardware {} not found", (Object)args[0]);
                    } else {
                        logger.info("UserHardware: {}", (Object)hardware);
                    }
                }
            });
            map.put("getuserhardware", (Command)new SubCommand("[username]", "get hardware by username", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    UserSupportHardware hardware;
                    this.verifyArgs(args, 1);
                    User user = AuthCoreProvider.this.getUserByUUID(UUID.fromString(args[0]));
                    if (user == null) {
                        logger.info("User {} not found", (Object)args[0]);
                    }
                    if ((hardware = this.val$instance.fetchUserHardware(user)) == null) {
                        logger.error("Method fetchUserHardware return null");
                        return;
                    }
                    UserHardware userHardware = hardware.getHardware();
                    if (userHardware == null) {
                        logger.info("User {} not contains hardware info", (Object)args[0]);
                    } else {
                        logger.info("UserHardware: {}", (Object)userHardware);
                        logger.info("HardwareInfo(JSON): {}", (Object)Launcher.gsonManager.gson.toJson((Object)userHardware.getHardwareInfo()));
                    }
                }
            });
            map.put("findmulti", (Command)new SubCommand("[hardware id]", "get all users in one hardware id", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 1);
                    UserHardware hardware = this.val$instance.getHardwareInfoById(args[0]);
                    if (hardware == null) {
                        logger.info("UserHardware {} not found", (Object)args[0]);
                        return;
                    }
                    Iterable<User> users = this.val$instance.getUsersByHardwareInfo(hardware);
                    for (User user : users) {
                        logger.info("User {}", (Object)user);
                    }
                }
            });
            map.put("banhardware", (Command)new SubCommand("[hardware id]", "ban hardware by id", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 1);
                    UserHardware hardware = this.val$instance.getHardwareInfoById(args[0]);
                    if (hardware == null) {
                        logger.info("UserHardware {} not found", (Object)args[0]);
                        return;
                    }
                    this.val$instance.banHardware(hardware);
                    logger.info("UserHardware {} banned", (Object)args[0]);
                }
            });
            map.put("unbanhardware", (Command)new SubCommand("[hardware id]", "ban hardware by id", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 1);
                    UserHardware hardware = this.val$instance.getHardwareInfoById(args[0]);
                    if (hardware == null) {
                        logger.info("UserHardware {} not found", (Object)args[0]);
                        return;
                    }
                    this.val$instance.unbanHardware(hardware);
                    logger.info("UserHardware {} unbanned", (Object)args[0]);
                }
            });
            map.put("comparehardware", (Command)new SubCommand("[json data 1] [json data 2]", "compare hardware info", (AuthSupportHardware)instance){
                final /* synthetic */ AuthSupportHardware val$instance;
                {
                    this.val$instance = authSupportHardware;
                    super(arg0, arg1);
                }

                public void invoke(String ... args) throws Exception {
                    this.verifyArgs(args, 2);
                    HardwareReportRequest.HardwareInfo hardware1 = (HardwareReportRequest.HardwareInfo)Launcher.gsonManager.gson.fromJson(args[0], HardwareReportRequest.HardwareInfo.class);
                    HardwareReportRequest.HardwareInfo hardware2 = (HardwareReportRequest.HardwareInfo)Launcher.gsonManager.gson.fromJson(args[1], HardwareReportRequest.HardwareInfo.class);
                    HWIDProvider.HardwareInfoCompareResult result = this.val$instance.compareHardwareInfo(hardware1, hardware2);
                    if (result == null) {
                        logger.error("Method compareHardwareInfo return null");
                        return;
                    }
                    logger.info("Compare result: {} Spoof: {} first {} second", (Object)result.compareLevel, (Object)result.firstSpoofingLevel, (Object)result.secondSpoofingLevel);
                }
            });
        }
        return map;
    }

    public User checkServer(Client client, String username, String serverID) throws IOException {
        User user = this.getUserByUsername(username);
        if (user == null) {
            return null;
        }
        if (user.getUsername().equals(username) && user.getServerId().equals(serverID)) {
            return user;
        }
        return null;
    }

    public boolean joinServer(Client client, String username, String accessToken, String serverID) throws IOException {
        User user = client.getUser();
        if (user == null) {
            return false;
        }
        return user.getUsername().equals(username) && user.getAccessToken().equals(accessToken) && this.updateServerID(user, serverID);
    }

    public <T> T isSupport(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public abstract void close() throws IOException;

    public static class OAuthAccessTokenExpired
    extends Exception {
        public OAuthAccessTokenExpired() {
        }

        public OAuthAccessTokenExpired(String message) {
            super(message);
        }

        public OAuthAccessTokenExpired(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class PasswordVerifyReport {
        public static final PasswordVerifyReport REQUIRED_2FA = new PasswordVerifyReport(-1);
        public static final PasswordVerifyReport FAILED = new PasswordVerifyReport(false);
        public static final PasswordVerifyReport OK = new PasswordVerifyReport(true);
        public final boolean success;
        public final boolean needMoreFactor;
        public final List<Integer> factors;

        public PasswordVerifyReport(boolean success) {
            this.success = success;
            this.needMoreFactor = false;
            this.factors = List.of();
        }

        public PasswordVerifyReport(int nextFactor) {
            this.success = false;
            this.needMoreFactor = true;
            this.factors = List.of(Integer.valueOf(nextFactor));
        }

        public PasswordVerifyReport(List<Integer> factors) {
            this.success = false;
            this.needMoreFactor = false;
            this.factors = Collections.unmodifiableList(factors);
        }

        private PasswordVerifyReport(boolean success, boolean needMoreFactor, List<Integer> factors) {
            this.success = success;
            this.needMoreFactor = needMoreFactor;
            this.factors = factors;
        }
    }
}

