/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.password.PasswordVerifier;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;

public class JsonCoreProvider
extends AuthCoreProvider {
    private static final transient Logger logger = LogManager.getLogger();
    public String getUserByUsernameUrl;
    public String getUserByLoginUrl;
    public String getUserByUUIDUrl;
    public String getUserSessionByOAuthAccessTokenUrl;
    public String getAuthDetailsUrl;
    public String refreshAccessTokenUrl;
    public String verifyPasswordUrl;
    public String createOAuthSessionUrl;
    public String updateServerIdUrl;
    public String joinServerUrl;
    public String checkServerUrl;
    public String bearerToken;
    public PasswordVerifier passwordVerifier;
    private transient HttpClient client;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, R> R jsonRequest(T request, String url, String bearerToken, Class<R> clazz, HttpClient client) {
        HttpRequest.BodyPublisher publisher = request != null ? HttpRequest.BodyPublishers.ofString(Launcher.gsonManager.gson.toJson(request)) : HttpRequest.BodyPublishers.noBody();
        try {
            HttpResponse<InputStream> response;
            int statusCode;
            HttpRequest.Builder request1 = HttpRequest.newBuilder().method("POST", publisher).uri(new URI(url)).header("Content-Type", "application/json; charset=UTF-8").header("Accept", "application/json").timeout(Duration.ofMillis(10000L));
            if (bearerToken != null) {
                request1.header("Authorization", "Bearer ".concat(bearerToken));
            }
            if (200 > (statusCode = (response = client.send(request1.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode()) || statusCode > 300) {
                if (statusCode >= 500) {
                    logger.error("JsonCoreProvider: {} return {}", (Object)url, (Object)statusCode);
                    return null;
                }
                if (statusCode >= 300 && statusCode <= 400) {
                    logger.error("JsonCoreProvider: {} return {}, try redirect to {}. Redirects not supported!", (Object)url, (Object)statusCode, (Object)response.headers().firstValue("Location").orElse("Unknown"));
                    return null;
                }
                if (statusCode != 403) {
                    if (statusCode != 401) return null;
                }
                logger.error("JsonCoreProvider: {} return {}. Please set 'bearerToken'!", (Object)url, (Object)statusCode);
                return null;
            }
            try (InputStreamReader reader = new InputStreamReader(response.body());){
                Object object = Launcher.gsonManager.gson.fromJson((Reader)reader, clazz);
                return (R)object;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public User getUserByUsername(String username) {
        return this.jsonRequest(new JsonGetUserByUsername(username), this.getUserByUsernameUrl, JsonUser.class);
    }

    @Override
    public User getUserByLogin(String login) {
        if (this.getUserByLoginUrl != null) {
            return this.jsonRequest(new JsonGetUserByUsername(login), this.getUserByLoginUrl, JsonUser.class);
        }
        return super.getUserByLogin(login);
    }

    @Override
    public User getUserByUUID(UUID uuid) {
        return this.jsonRequest(new JsonGetUserByUUID(uuid), this.getUserByUUIDUrl, JsonUser.class);
    }

    @Override
    public UserSession getUserSessionByOAuthAccessToken(String accessToken) throws AuthCoreProvider.OAuthAccessTokenExpired {
        if (this.getUserSessionByOAuthAccessTokenUrl == null) {
            return null;
        }
        JsonGetUserSessionByOAuthTokenResponse response = this.jsonRequest(new JsonGetUserSessionByAccessToken(accessToken), this.getUserSessionByOAuthAccessTokenUrl, JsonGetUserSessionByOAuthTokenResponse.class);
        if (response == null) {
            return null;
        }
        if (!response.expired) {
            throw new AuthCoreProvider.OAuthAccessTokenExpired();
        }
        return response.session;
    }

    @Override
    public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getDetails(Client client) {
        if (this.getAuthDetailsUrl != null) {
            JsonGetDetailsResponse response = this.jsonRequest(new JsonGetDetails(), this.getAuthDetailsUrl, JsonGetDetailsResponse.class);
            if (response == null) {
                return super.getDetails(client);
            }
            return response.details;
        }
        return super.getDetails(client);
    }

    @Override
    public AuthManager.AuthReport refreshAccessToken(String refreshToken, AuthResponse.AuthContext context) {
        JsonAuthReportResponse response = this.jsonRequest(new JsonRefreshToken(refreshToken, context.ip), this.refreshAccessTokenUrl, JsonAuthReportResponse.class);
        return response == null ? null : response.toAuthReport();
    }

    @Override
    public void verifyAuth(AuthResponse.AuthContext context) throws AuthException {
    }

    @Override
    public AuthCoreProvider.PasswordVerifyReport verifyPassword(User user, AuthRequest.AuthPasswordInterface password) {
        JsonUser jsonUser = (JsonUser)user;
        if (password instanceof AuthPlainPassword && jsonUser.password != null && this.passwordVerifier != null) {
            if (this.passwordVerifier.check(jsonUser.password, ((AuthPlainPassword)password).password)) {
                return AuthCoreProvider.PasswordVerifyReport.OK;
            }
            return AuthCoreProvider.PasswordVerifyReport.FAILED;
        }
        if (user == null) {
            return this.jsonRequest(new JsonPasswordVerify(null, null, password), this.verifyPasswordUrl, AuthCoreProvider.PasswordVerifyReport.class);
        }
        return this.jsonRequest(new JsonPasswordVerify(user.getUsername(), user.getUUID(), password), this.verifyPasswordUrl, AuthCoreProvider.PasswordVerifyReport.class);
    }

    @Override
    public AuthManager.AuthReport createOAuthSession(User user, AuthResponse.AuthContext context, AuthCoreProvider.PasswordVerifyReport report, boolean minecraftAccess) throws IOException {
        JsonAuthReportResponse response = this.jsonRequest(new JsonCreateOAuthSession(user == null ? null : user.getUsername(), user == null ? null : user.getUUID(), minecraftAccess), this.createOAuthSessionUrl, JsonAuthReportResponse.class);
        if (response == null) {
            return null;
        }
        if (response.error != null) {
            throw new AuthException(response.error);
        }
        JsonUser user1 = (JsonUser)user;
        user1.accessToken = response.minecraftAccessToken;
        return response.toAuthReport();
    }

    @Override
    public void init(LaunchServer server) {
        this.client = HttpClient.newBuilder().build();
    }

    @Override
    public User checkServer(Client client, String username, String serverID) throws IOException {
        if (this.checkServerUrl == null) {
            return super.checkServer(client, username, serverID);
        }
        return this.jsonRequest(new JsonCheckServer(username, serverID), this.checkServerUrl, JsonUser.class);
    }

    @Override
    public boolean joinServer(Client client, String username, String accessToken, String serverID) throws IOException {
        if (this.joinServerUrl == null) {
            return super.joinServer(client, username, accessToken, serverID);
        }
        return this.jsonRequest(new JsonJoinServer((String)username, (String)accessToken, (String)serverID), (String)this.joinServerUrl, JsonSuccessResponse.class).success;
    }

    @Override
    protected boolean updateServerID(User user, String serverID) throws IOException {
        JsonUser jsonUser = (JsonUser)user;
        if (this.updateServerIdUrl == null) {
            return false;
        }
        jsonUser.serverId = serverID;
        JsonSuccessResponse successResponse = this.jsonRequest(new JsonUpdateServerId(user.getUsername(), user.getUUID(), serverID), this.updateServerIdUrl, JsonSuccessResponse.class);
        if (successResponse == null) {
            return false;
        }
        return successResponse.success;
    }

    @Override
    public void close() throws IOException {
    }

    public <T, R> R jsonRequest(T request, String url, Class<R> clazz) {
        return JsonCoreProvider.jsonRequest(request, url, this.bearerToken, clazz, this.client);
    }

    public static class JsonGetUserByUsername {
        public String username;

        public JsonGetUserByUsername(String username) {
            this.username = username;
        }
    }

    public static class JsonUser
    implements User {
        private String username;
        private UUID uuid;
        private String serverId;
        private String accessToken;
        private ClientPermissions permissions;
        private String password;

        public JsonUser() {
        }

        public JsonUser(String username, UUID uuid, String serverId, String accessToken, ClientPermissions permissions, String password) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
            this.accessToken = accessToken;
            this.permissions = permissions;
            this.password = password;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public String getServerId() {
            return this.serverId;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public ClientPermissions getPermissions() {
            return this.permissions;
        }

        public String toString() {
            return "JsonUser{username='" + this.username + "', uuid=" + this.uuid + ", permissions=" + this.permissions + "}";
        }
    }

    public static class JsonGetUserByUUID {
        public UUID uuid;

        public JsonGetUserByUUID(UUID uuid) {
            this.uuid = uuid;
        }
    }

    public static class JsonGetUserSessionByAccessToken {
        public String accessToken;

        public JsonGetUserSessionByAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }
    }

    public static class JsonGetUserSessionByOAuthTokenResponse {
        public boolean expired;
        public JsonUserSession session;
    }

    public static class JsonUserSession
    implements UserSession {
        public String id;
        public JsonUser user;
        public long expireIn;

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public User getUser() {
            return this.user;
        }

        @Override
        public long getExpireIn() {
            return this.expireIn;
        }

        public String toString() {
            return "JsonUserSession{id='" + this.id + "'user='" + (this.user == null ? null : this.user.getUsername()) + "', expireIn=" + this.expireIn + "}";
        }
    }

    public static class JsonGetDetails {
    }

    public static class JsonGetDetailsResponse {
        public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> details;
    }

    public static class JsonRefreshToken {
        public String refreshToken;
        public String ip;

        public JsonRefreshToken(String refreshToken, String ip) {
            this.refreshToken = refreshToken;
            this.ip = ip;
        }
    }

    public static class JsonAuthReportResponse {
        public String minecraftAccessToken;
        public String oauthAccessToken;
        public String oauthRefreshToken;
        public long oauthExpire;
        public JsonUserSession session;
        public String error;

        public AuthManager.AuthReport toAuthReport() {
            return new AuthManager.AuthReport(this.minecraftAccessToken, this.oauthAccessToken, this.oauthRefreshToken, this.oauthExpire, this.session);
        }
    }

    public static class JsonPasswordVerify {
        public String username;
        public UUID uuid;
        public AuthRequest.AuthPasswordInterface password;

        public JsonPasswordVerify(String username, UUID uuid, AuthRequest.AuthPasswordInterface password) {
            this.username = username;
            this.uuid = uuid;
            this.password = password;
        }
    }

    public static class JsonCreateOAuthSession {
        public String username;
        public UUID uuid;
        public boolean minecraftAccess;

        public JsonCreateOAuthSession(String username, UUID uuid, boolean minecraftAccess) {
            this.username = username;
            this.uuid = uuid;
            this.minecraftAccess = minecraftAccess;
        }
    }

    public static class JsonCheckServer {
        public String username;
        public String serverId;

        public JsonCheckServer(String username, String serverId) {
            this.username = username;
            this.serverId = serverId;
        }
    }

    public static class JsonJoinServer {
        public String username;
        public String accessToken;
        public String serverId;

        public JsonJoinServer(String username, String accessToken, String serverId) {
            this.username = username;
            this.accessToken = accessToken;
            this.serverId = serverId;
        }
    }

    public static class JsonSuccessResponse {
        public boolean success;
    }

    public static class JsonUpdateServerId {
        public String username;
        public UUID uuid;
        public String serverId;

        public JsonUpdateServerId(String username, UUID uuid, String serverId) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
        }
    }
}

