/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.handler;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.MySQLSourceConfig;
import pro.gravit.launchserver.auth.handler.CachedAuthHandler;

public final class MySQLAuthHandler
extends CachedAuthHandler {
    private final transient Logger logger = LogManager.getLogger();
    private MySQLSourceConfig mySQLHolder;
    private String uuidColumn;
    private String usernameColumn;
    private String accessTokenColumn;
    private String serverIDColumn;
    private String table;
    private transient String queryByUUIDSQL;
    private transient String queryByUsernameSQL;
    private transient String updateAuthSQL;
    private transient String updateServerIDSQL;

    @Override
    public void init(LaunchServer srv) {
        super.init(srv);
        if (this.mySQLHolder == null) {
            this.logger.error("mySQLHolder cannot be null");
        }
        if (this.uuidColumn == null) {
            this.logger.error("uuidColumn cannot be null");
        }
        if (this.usernameColumn == null) {
            this.logger.error("usernameColumn cannot be null");
        }
        if (this.accessTokenColumn == null) {
            this.logger.error("accessTokenColumn cannot be null");
        }
        if (this.serverIDColumn == null) {
            this.logger.error("serverIDColumn cannot be null");
        }
        if (this.table == null) {
            this.logger.error("table cannot be null");
        }
        this.queryByUUIDSQL = String.format("SELECT %s, %s, %s, %s FROM %s WHERE %s=? LIMIT 1", this.uuidColumn, this.usernameColumn, this.accessTokenColumn, this.serverIDColumn, this.table, this.uuidColumn);
        this.queryByUsernameSQL = String.format("SELECT %s, %s, %s, %s FROM %s WHERE %s=? LIMIT 1", this.uuidColumn, this.usernameColumn, this.accessTokenColumn, this.serverIDColumn, this.table, this.usernameColumn);
        this.updateAuthSQL = String.format("UPDATE %s SET %s=?, %s=?, %s=NULL WHERE %s=? LIMIT 1", this.table, this.usernameColumn, this.accessTokenColumn, this.serverIDColumn, this.uuidColumn);
        this.updateServerIDSQL = String.format("UPDATE %s SET %s=? WHERE %s=? LIMIT 1", this.table, this.serverIDColumn, this.uuidColumn);
    }

    @Override
    public void close() {
        this.mySQLHolder.close();
    }

    private CachedAuthHandler.Entry constructEntry(ResultSet set) throws SQLException {
        return set.next() ? new CachedAuthHandler.Entry(UUID.fromString(set.getString(this.uuidColumn)), set.getString(this.usernameColumn), set.getString(this.accessTokenColumn), set.getString(this.serverIDColumn)) : null;
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(String username) throws IOException {
        return this.query(this.queryByUsernameSQL, username);
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(UUID uuid) throws IOException {
        return this.query(this.queryByUUIDSQL, uuid.toString());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private CachedAuthHandler.Entry query(String sql, String value) throws IOException {
        try (Connection c = this.mySQLHolder.getConnection();){
            CachedAuthHandler.Entry entry;
            block14: {
                PreparedStatement s = c.prepareStatement(sql);
                s.setString(1, value);
                s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                ResultSet set = s.executeQuery();
                try {
                    entry = this.constructEntry(set);
                    if (set == null) break block14;
                }
                catch (Throwable throwable) {
                    if (set != null) {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                set.close();
            }
            return entry;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected boolean updateAuth(UUID uuid, String username, String accessToken) throws IOException {
        boolean bl;
        block8: {
            Connection c = this.mySQLHolder.getConnection();
            try {
                PreparedStatement s = c.prepareStatement(this.updateAuthSQL);
                s.setString(1, username);
                s.setString(2, accessToken);
                s.setString(3, uuid.toString());
                s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                boolean bl2 = bl = s.executeUpdate() > 0;
                if (c == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            c.close();
        }
        return bl;
    }

    @Override
    protected boolean updateServerID(UUID uuid, String serverID) throws IOException {
        boolean bl;
        block8: {
            Connection c = this.mySQLHolder.getConnection();
            try {
                PreparedStatement s = c.prepareStatement(this.updateServerIDSQL);
                s.setString(1, serverID);
                s.setString(2, uuid.toString());
                s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                boolean bl2 = bl = s.executeUpdate() > 0;
                if (c == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            c.close();
        }
        return bl;
    }
}

