/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.protect.hwid;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.protect.hwid.HWIDException;
import pro.gravit.launchserver.auth.protect.hwid.HWIDProvider;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.SecurityHelper;

public class MemoryHWIDProvider
extends HWIDProvider
implements Reconfigurable {
    private final transient Logger logger = LogManager.getLogger();
    public double warningSpoofingLevel = -1.0;
    public double criticalCompareLevel = 1.0;
    public transient Set<MemoryHWIDEntity> db = ConcurrentHashMap.newKeySet();

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("hardwarelist", (Command)new SubCommand(){

            public void invoke(String ... args) {
                for (MemoryHWIDEntity e : MemoryHWIDProvider.this.db) {
                    MemoryHWIDProvider.this.printHardwareInfo(e.hardware);
                    MemoryHWIDProvider.this.logger.info("ID {} banned {}", (Object)e.id, (Object)(e.banned ? "true" : "false"));
                    MemoryHWIDProvider.this.logger.info("PublicKey Hash: {}", (Object)SecurityHelper.toHex((byte[])SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA1, (byte[])e.publicKey)));
                }
            }
        });
        commands.put("hardwareban", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                long id = Long.parseLong(args[0]);
                for (MemoryHWIDEntity e : MemoryHWIDProvider.this.db) {
                    if (e.id != id) continue;
                    e.banned = true;
                    MemoryHWIDProvider.this.logger.info("HardwareID {} banned", (Object)e.id);
                }
            }
        });
        return commands;
    }

    @Override
    public HardwareReportRequest.HardwareInfo findHardwareInfoByPublicKey(byte[] publicKey, Client client) throws HWIDException {
        for (MemoryHWIDEntity e : this.db) {
            if (!Arrays.equals(e.publicKey, publicKey)) continue;
            if (e.banned) {
                throw new HWIDException("You HWID banned");
            }
            return e.hardware;
        }
        return null;
    }

    @Override
    public void createHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, Client client) {
        this.db.add(new MemoryHWIDEntity(hardwareInfo, publicKey));
    }

    @Override
    public boolean addPublicKeyToHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, Client client) throws HWIDException {
        boolean isAlreadyWarning = false;
        for (MemoryHWIDEntity e : this.db) {
            HWIDProvider.HardwareInfoCompareResult result = this.compareHardwareInfo(e.hardware, hardwareInfo);
            if (this.warningSpoofingLevel > 0.0 && result.firstSpoofingLevel > this.warningSpoofingLevel && !isAlreadyWarning) {
                this.logger.warn("HardwareInfo spoofing level too high: {}", (Object)result.firstSpoofingLevel);
                isAlreadyWarning = true;
            }
            if (!(result.compareLevel > this.criticalCompareLevel)) continue;
            this.logger.debug("HardwareInfo publicKey change: compareLevel {}", (Object)result.compareLevel);
            if (e.banned) {
                throw new HWIDException("You HWID banned");
            }
            e.publicKey = publicKey;
            return true;
        }
        return false;
    }

    static class MemoryHWIDEntity {
        public HardwareReportRequest.HardwareInfo hardware;
        public byte[] publicKey;
        public boolean banned;
        public long id;

        public MemoryHWIDEntity(HardwareReportRequest.HardwareInfo hardware, byte[] publicKey) {
            this.hardware = hardware;
            this.publicKey = publicKey;
            this.id = SecurityHelper.newRandom().nextLong();
        }
    }
}

