/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.provider;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class RequestAuthProvider
extends AuthProvider {
    private final transient HttpClient client = HttpClient.newBuilder().build();
    public String url;
    public transient Pattern pattern;
    public String response;
    public boolean flagsEnabled;
    public boolean usePermission = true;
    public int timeout = 5000;

    @Override
    public void init(LaunchServer srv) {
        super.init(srv);
        if (this.url == null) {
            throw new RuntimeException("[Verify][AuthProvider] url cannot be null");
        }
        if (this.response == null) {
            throw new RuntimeException("[Verify][AuthProvider] response cannot be null");
        }
        this.pattern = Pattern.compile(this.response);
    }

    @Override
    public AuthProviderResult auth(String login, AuthRequest.AuthPasswordInterface password, String ip) throws IOException, URISyntaxException, InterruptedException {
        if (!(password instanceof AuthPlainPassword)) {
            throw new AuthException("This password type not supported");
        }
        HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().uri(new URI(this.getFormattedURL(login, ((AuthPlainPassword)password).password, ip))).header("User-Agent", IOHelper.USER_AGENT).timeout(Duration.ofMillis(this.timeout)).GET().build(), HttpResponse.BodyHandlers.ofString());
        String currentResponse = response.body();
        Matcher matcher = this.pattern.matcher(currentResponse);
        return matcher.matches() && matcher.groupCount() >= 1 ? new AuthProviderResult(matcher.group("username"), SecurityHelper.randomStringToken(), new ClientPermissions(this.usePermission ? Long.parseLong(matcher.group("permissions")) : 0L, this.flagsEnabled ? Long.parseLong(matcher.group("flags")) : 0L)) : RequestAuthProvider.authError(currentResponse);
    }

    @Override
    public void close() {
    }

    private String getFormattedURL(String login, String password, String ip) {
        return CommonHelper.replace((String)this.url, (String[])new String[]{"login", IOHelper.urlEncode((String)login), "password", IOHelper.urlEncode((String)password), "ip", IOHelper.urlEncode((String)ip)});
    }
}

