/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.request.management.PingServerReportRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;

public class PingServersCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public PingServersCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[]";
    }

    public String getUsageDescription() {
        return "show modern pings status";
    }

    public void invoke(String ... args) {
        this.server.pingServerManager.map.forEach((name, data) -> {
            this.logger.info("[{}] online {} / {}", name, (Object)(data.lastReport == null ? -1 : data.lastReport.playersOnline), (Object)(data.lastReport == null ? -1 : data.lastReport.maxPlayers));
            if (data.lastReport != null && data.lastReport.users != null) {
                for (PingServerReportRequest.PingServerReport.UsernameInfo user : data.lastReport.users) {
                    this.logger.info("User {}", (Object)(user.username == null ? "null" : user.username));
                }
            }
        });
    }
}

