/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.dao.provider;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.dao.User;
import pro.gravit.launchserver.dao.UserDAO;
import pro.gravit.launchserver.dao.provider.DaoProvider;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;

@Deprecated
public abstract class HibernateDaoProvider
extends DaoProvider
implements Reconfigurable,
AutoCloseable {
    public String driver;
    public String url;
    public String username;
    public String password;
    public String dialect;
    public String pool_size;
    public String hibernateConfig;
    public boolean parallelHibernateInit;
    protected transient SessionFactory sessionFactory;

    @Override
    public void init(LaunchServer server) {
        Runnable init = () -> {
            Configuration cfg = new Configuration().setProperty("hibernate.connection.driver_class", this.driver).setProperty("hibernate.connection.url", this.url).setProperty("hibernate.connection.username", this.username).setProperty("hibernate.connection.password", this.password).setProperty("hibernate.connection.pool_size", this.pool_size);
            if (this.dialect != null) {
                cfg.setProperty("hibernate.dialect", this.dialect);
            }
            if (this.hibernateConfig != null) {
                cfg.configure(Paths.get(this.hibernateConfig, new String[0]).toFile());
            }
            this.onConfigure(cfg);
            this.sessionFactory = cfg.buildSessionFactory();
            this.userDAO = this.newUserDAO();
        };
        if (this.parallelHibernateInit) {
            CommonHelper.newThread((String)"Hibernate Thread", (boolean)true, (Runnable)init);
        } else {
            init.run();
        }
    }

    protected abstract void onConfigure(Configuration var1);

    protected abstract UserDAO newUserDAO();

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("getallusers", (Command)new SubCommand(){

            public void invoke(String ... args) {
                int count = 0;
                for (User user : HibernateDaoProvider.this.userDAO.findAll()) {
                    LogHelper.subInfo((String)"[%s] UUID: %s", (Object[])new Object[]{user.getUsername(), user.getUuid().toString()});
                    ++count;
                }
                LogHelper.info((String)"Print %d users", (Object[])new Object[]{count});
            }
        });
        commands.put("getuser", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                User user = HibernateDaoProvider.this.userDAO.findByUsername(args[0]);
                if (user == null) {
                    LogHelper.error((String)"User %s not found", (Object[])new Object[]{args[0]});
                    return;
                }
                LogHelper.info((String)"[%s] UUID: %s | permissions %s", (Object[])new Object[]{user.getUsername(), user.getUuid().toString(), user.getPermissions() == null ? "null" : user.getPermissions().toString()});
            }
        });
        commands.put("givepermission", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 3);
                User user = HibernateDaoProvider.this.userDAO.findByUsername(args[0]);
                if (user == null) {
                    LogHelper.error((String)"User %s not found", (Object[])new Object[]{args[0]});
                    return;
                }
                ClientPermissions permissions = user.getPermissions();
                long perm = Long.parseLong(args[1]);
                boolean value = Boolean.parseBoolean(args[2]);
                permissions.setPermission(perm, value);
                user.setPermissions(permissions);
                HibernateDaoProvider.this.userDAO.update(user);
            }
        });
        commands.put("giveflag", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 3);
                User user = HibernateDaoProvider.this.userDAO.findByUsername(args[0]);
                if (user == null) {
                    LogHelper.error((String)"User %s not found", (Object[])new Object[]{args[0]});
                    return;
                }
                ClientPermissions permissions = user.getPermissions();
                long perm = Long.parseLong(args[1]);
                boolean value = Boolean.parseBoolean(args[2]);
                permissions.setFlag(perm, value);
                user.setPermissions(permissions);
                HibernateDaoProvider.this.userDAO.update(user);
            }
        });
        return commands;
    }

    @Override
    public void close() {
        this.sessionFactory.close();
    }
}

