/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import java.io.IOException;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.request.auth.password.AuthAESPassword;
import pro.gravit.launcher.request.auth.password.AuthECPassword;
import pro.gravit.launcher.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.request.auth.password.AuthOAuthPassword;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.request.auth.password.AuthRSAPassword;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.AuthSocialProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportTextures;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderDAOResult;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.launchserver.auth.texture.TextureProvider;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class AuthManager {
    private final transient LaunchServer server;
    private final transient Logger logger = LogManager.getLogger();

    public AuthManager(LaunchServer server) {
        this.server = server;
    }

    public AuthResponse.AuthContext makeAuthContext(Client client, AuthResponse.ConnectTypes authType, AuthProviderPair pair, String login, String profileName, String ip) {
        Objects.requireNonNull(client, "Client must be not null");
        Objects.requireNonNull(authType, "authType must be not null");
        Objects.requireNonNull(pair, "AuthProviderPair must be not null");
        return new AuthResponse.AuthContext(client, login, profileName, ip, authType, pair);
    }

    public void check(AuthResponse.AuthContext context) throws AuthException {
        if (context.authType == AuthResponse.ConnectTypes.CLIENT && !context.client.checkSign) {
            AuthProvider.authError("Don't skip Launcher Update");
            return;
        }
        if (context.client.isAuth) {
            AuthProvider.authError("You are already logged in");
            return;
        }
    }

    public AuthReport auth(AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password) throws AuthException {
        AuthReport report;
        AuthProviderPair pair = context.pair;
        if (pair.core == null) {
            try {
                report = AuthReport.ofMinecraftAccessToken(this.authWithProviderAndHandler(context, password));
            }
            catch (Exception e) {
                if (e instanceof AuthException) {
                    throw (AuthException)e;
                }
                throw new AuthException("Internal Auth Error. Please contact administrator");
            }
        } else {
            report = this.authWithCore(context, password);
        }
        return report;
    }

    private String authWithProviderAndHandler(AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password) throws Exception {
        String accessToken;
        UUID uuid;
        String username;
        context.pair.provider.preAuth(context.login, password, context.ip);
        AuthProviderResult aresult = context.pair.provider.auth(context.login, password, context.ip);
        String string = username = aresult.username != null ? aresult.username : context.login;
        if (aresult instanceof AuthProviderDAOResult) {
            context.client.daoObject = ((AuthProviderDAOResult)aresult).daoObject;
        }
        if (context.authType == AuthResponse.ConnectTypes.CLIENT && this.server.config.protectHandler.allowGetAccessToken(context)) {
            uuid = context.pair.handler.auth(aresult);
            accessToken = aresult.accessToken;
        } else {
            uuid = context.pair.handler.usernameToUUID(aresult.username);
            accessToken = null;
        }
        this.internalAuth(context.client, context.authType, context.pair, username, uuid, aresult.permissions, false);
        return accessToken;
    }

    private AuthReport authWithCore(AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password) throws AuthException {
        AuthSocialProvider.SocialResult result;
        AuthCoreProvider provider = context.pair.core;
        provider.verifyAuth(context);
        if (password instanceof AuthOAuthPassword) {
            User user;
            UserSession session;
            AuthOAuthPassword password1 = (AuthOAuthPassword)password;
            try {
                session = provider.getUserSessionByOAuthAccessToken(password1.accessToken);
            }
            catch (AuthCoreProvider.OAuthAccessTokenExpired oAuthAccessTokenExpired) {
                throw new AuthException("auth.expiretoken");
            }
            if (session == null) {
                throw new AuthException("auth.invalidtoken");
            }
            context.client.coreObject = user = session.getUser();
            context.client.sessionObject = session;
            this.internalAuth(context.client, context.authType, context.pair, user.getUsername(), user.getUUID(), user.getPermissions(), true);
            if (context.authType == AuthResponse.ConnectTypes.CLIENT && this.server.config.protectHandler.allowGetAccessToken(context)) {
                return AuthReport.ofMinecraftAccessToken(user.getAccessToken());
            }
            return AuthReport.ofMinecraftAccessToken(null);
        }
        User user = null;
        boolean skipPasswordCheck = false;
        String login = context.login;
        if (context.pair.social != null && (result = context.pair.social.preAuth(context, password)) != null) {
            if (result.user != null) {
                user = result.user;
            }
            if (result.login != null) {
                login = result.login;
            }
            if (result.password != null) {
                password = result.password;
            }
            if (result.user != null && result.password == null) {
                skipPasswordCheck = true;
            }
        }
        if (user == null && login != null && (user = provider.getUserByLogin(context.login)) == null) {
            throw new AuthException("auth.usernotfound");
        }
        AuthCoreProvider.PasswordVerifyReport report = null;
        if (!skipPasswordCheck) {
            report = provider.verifyPassword(user, password);
        }
        if (skipPasswordCheck || report.success) {
            AuthReport result2;
            try {
                result2 = provider.createOAuthSession(user, context, report, context.authType == AuthResponse.ConnectTypes.CLIENT && this.server.config.protectHandler.allowGetAccessToken(context));
            }
            catch (IOException e) {
                if (e instanceof AuthException) {
                    throw (AuthException)e;
                }
                this.logger.error((Object)e);
                throw new AuthException("Internal Auth Error");
            }
            if (user == null) {
                if (result2.session != null) {
                    user = result2.session.getUser();
                } else {
                    this.logger.error("AuthCoreProvider {} method createOAuthSession returns null session with login null", (Object)context.pair.name);
                    throw new AuthException("Internal Auth Error");
                }
            }
            context.client.coreObject = user;
            this.internalAuth(context.client, context.authType, context.pair, user.getUsername(), user.getUUID(), user.getPermissions(), result2.isUsingOAuth());
            return result2;
        }
        if (report.needMoreFactor) {
            if (report.factors.size() == 1 && report.factors.get(0) == -1) {
                throw new AuthException("auth.require2fa");
            }
            String message = "auth.require.factor.".concat(report.factors.stream().map(String::valueOf).collect(Collectors.joining(".")));
            throw new AuthException(message);
        }
        throw new AuthException("auth.wrongpassword");
    }

    public void internalAuth(Client client, AuthResponse.ConnectTypes authType, AuthProviderPair pair, String username, UUID uuid, ClientPermissions permissions, boolean oauth) {
        client.isAuth = true;
        client.permissions = permissions;
        client.auth_id = pair.name;
        client.auth = pair;
        client.username = username;
        client.type = authType;
        client.uuid = uuid;
        client.useOAuth = oauth;
        if (pair.isUseCore() && client.coreObject == null) {
            client.coreObject = pair.core.getUserByUUID(uuid);
        }
    }

    public CheckServerReport checkServer(Client client, String username, String serverID) throws IOException {
        if (client.auth == null) {
            return null;
        }
        if (client.auth.isUseCore()) {
            User user = client.auth.core.checkServer(client, username, serverID);
            if (user == null) {
                return null;
            }
            return CheckServerReport.ofUser(user, this.getPlayerProfile(client.auth, user));
        }
        UUID uuid = client.auth.handler.checkServer(username, serverID);
        return uuid == null ? null : CheckServerReport.ofUUID(uuid, this.getPlayerProfile(client.auth, uuid));
    }

    public boolean joinServer(Client client, String username, String accessToken, String serverID) throws IOException {
        if (client.auth == null) {
            return false;
        }
        if (client.auth.isUseCore()) {
            return client.auth.core.joinServer(client, username, accessToken, serverID);
        }
        return client.auth.handler.joinServer(username, accessToken, serverID);
    }

    public PlayerProfile getPlayerProfile(Client client) {
        if (client.auth == null) {
            return null;
        }
        if (client.useOAuth) {
            User user = client.getUser();
            if (user == null) {
                return null;
            }
            PlayerProfile playerProfile = this.getPlayerProfile(client.auth, user);
            if (playerProfile != null) {
                return playerProfile;
            }
        }
        if (client.auth.textureProvider != null) {
            return this.getPlayerProfile(client.uuid, client.username, client.profile == null ? null : client.profile.getTitle(), client.auth.textureProvider);
        }
        return new PlayerProfile(client.uuid, client.username, null, null);
    }

    public PlayerProfile getPlayerProfile(AuthProviderPair pair, String username) {
        return this.getPlayerProfile(pair, username, null);
    }

    public PlayerProfile getPlayerProfile(AuthProviderPair pair, String username, ClientProfile profile) {
        UUID uuid = null;
        if (pair.isUseCore()) {
            User user = pair.core.getUserByUsername(username);
            if (user == null) {
                return null;
            }
            PlayerProfile playerProfile = this.getPlayerProfile(pair, user);
            uuid = user.getUUID();
            if (playerProfile != null) {
                return playerProfile;
            }
        } else {
            try {
                uuid = pair.handler.usernameToUUID(username);
            }
            catch (IOException e) {
                this.logger.error("UsernameToUUID failed", (Throwable)e);
            }
        }
        if (uuid == null) {
            return null;
        }
        if (pair.textureProvider != null) {
            return this.getPlayerProfile(uuid, username, profile == null ? null : profile.getTitle(), pair.textureProvider);
        }
        return new PlayerProfile(uuid, username, null, null);
    }

    public PlayerProfile getPlayerProfile(AuthProviderPair pair, UUID uuid) {
        return this.getPlayerProfile(pair, uuid, null);
    }

    public PlayerProfile getPlayerProfile(AuthProviderPair pair, UUID uuid, ClientProfile profile) {
        String username = null;
        if (pair.isUseCore()) {
            User user = pair.core.getUserByUUID(uuid);
            if (user == null) {
                return null;
            }
            PlayerProfile playerProfile = this.getPlayerProfile(pair, user);
            username = user.getUsername();
            if (playerProfile != null) {
                return playerProfile;
            }
        } else {
            try {
                username = pair.handler.uuidToUsername(uuid);
            }
            catch (IOException e) {
                this.logger.error("UUIDToUsername failed", (Throwable)e);
            }
        }
        if (username == null) {
            return null;
        }
        if (pair.textureProvider != null) {
            return this.getPlayerProfile(uuid, username, profile == null ? null : profile.getTitle(), pair.textureProvider);
        }
        return new PlayerProfile(uuid, username, null, null);
    }

    public PlayerProfile getPlayerProfile(AuthProviderPair pair, User user) {
        if (user instanceof UserSupportTextures) {
            return new PlayerProfile(user.getUUID(), user.getUsername(), ((UserSupportTextures)((Object)user)).getSkinTexture(), ((UserSupportTextures)((Object)user)).getCloakTexture());
        }
        if (pair.textureProvider == null) {
            throw new NullPointerException("TextureProvider not found");
        }
        return this.getPlayerProfile(user.getUUID(), user.getUsername(), "", pair.textureProvider);
    }

    private PlayerProfile getPlayerProfile(UUID uuid, String username, String client, TextureProvider textureProvider) {
        TextureProvider.SkinAndCloakTextures textures = textureProvider.getTextures(uuid, username, client);
        return new PlayerProfile(uuid, username, textures.skin, textures.cloak);
    }

    public AuthRequest.AuthPasswordInterface decryptPassword(AuthRequest.AuthPasswordInterface password) throws AuthException {
        if (password instanceof Auth2FAPassword) {
            Auth2FAPassword auth2FAPassword = (Auth2FAPassword)password;
            auth2FAPassword.firstPassword = this.tryDecryptPasswordPlain(auth2FAPassword.firstPassword);
            auth2FAPassword.secondPassword = this.tryDecryptPasswordPlain(auth2FAPassword.secondPassword);
        } else if (password instanceof AuthMultiPassword) {
            AuthMultiPassword multiPassword = (AuthMultiPassword)password;
            ArrayList<AuthRequest.AuthPasswordInterface> list = new ArrayList<AuthRequest.AuthPasswordInterface>(multiPassword.list.size());
            for (AuthRequest.AuthPasswordInterface p : multiPassword.list) {
                list.add(this.tryDecryptPasswordPlain(p));
            }
            multiPassword.list = list;
        } else {
            password = this.tryDecryptPasswordPlain(password);
        }
        return password;
    }

    private AuthRequest.AuthPasswordInterface tryDecryptPasswordPlain(AuthRequest.AuthPasswordInterface password) throws AuthException {
        if (password instanceof AuthECPassword) {
            try {
                return new AuthPlainPassword(IOHelper.decode((byte[])SecurityHelper.decrypt((String)this.server.runtime.passwordEncryptKey, (byte[])((AuthECPassword)password).password)));
            }
            catch (Exception ignored) {
                throw new AuthException("Password decryption error");
            }
        }
        if (password instanceof AuthAESPassword) {
            try {
                return new AuthPlainPassword(IOHelper.decode((byte[])SecurityHelper.decrypt((String)this.server.runtime.passwordEncryptKey, (byte[])((AuthAESPassword)password).password)));
            }
            catch (Exception ignored) {
                throw new AuthException("Password decryption error");
            }
        }
        if (password instanceof AuthRSAPassword) {
            try {
                Cipher cipher = SecurityHelper.newRSADecryptCipher((RSAPrivateKey)this.server.keyAgreementManager.rsaPrivateKey);
                return new AuthPlainPassword(IOHelper.decode((byte[])cipher.doFinal(((AuthRSAPassword)password).password)));
            }
            catch (Exception ignored) {
                throw new AuthException("Password decryption error");
            }
        }
        return password;
    }

    public static class AuthReport {
        public final String minecraftAccessToken;
        public final String oauthAccessToken;
        public final String oauthRefreshToken;
        public final long oauthExpire;
        public final UserSession session;

        public AuthReport(String minecraftAccessToken, String oauthAccessToken, String oauthRefreshToken, long oauthExpire, UserSession session) {
            this.minecraftAccessToken = minecraftAccessToken;
            this.oauthAccessToken = oauthAccessToken;
            this.oauthRefreshToken = oauthRefreshToken;
            this.oauthExpire = oauthExpire;
            this.session = session;
        }

        public static AuthReport ofOAuth(String oauthAccessToken, String oauthRefreshToken, long oauthExpire) {
            return new AuthReport(null, oauthAccessToken, oauthRefreshToken, oauthExpire, null);
        }

        public static AuthReport ofOAuth(String oauthAccessToken, String oauthRefreshToken, long oauthExpire, UserSession session) {
            return new AuthReport(null, oauthAccessToken, oauthRefreshToken, oauthExpire, session);
        }

        public static AuthReport ofOAuthWithMinecraft(String minecraftAccessToken, String oauthAccessToken, String oauthRefreshToken, long oauthExpire) {
            return new AuthReport(minecraftAccessToken, oauthAccessToken, oauthRefreshToken, oauthExpire, null);
        }

        public static AuthReport ofOAuthWithMinecraft(String minecraftAccessToken, String oauthAccessToken, String oauthRefreshToken, long oauthExpire, UserSession session) {
            return new AuthReport(minecraftAccessToken, oauthAccessToken, oauthRefreshToken, oauthExpire, session);
        }

        public static AuthReport ofMinecraftAccessToken(String minecraftAccessToken) {
            return new AuthReport(minecraftAccessToken, null, null, 0L, null);
        }

        public boolean isUsingOAuth() {
            return this.oauthAccessToken != null || this.oauthRefreshToken != null;
        }
    }

    public static class CheckServerReport {
        public UUID uuid;
        public User user;
        public PlayerProfile playerProfile;

        public CheckServerReport(UUID uuid, User user, PlayerProfile playerProfile) {
            this.uuid = uuid;
            this.user = user;
            this.playerProfile = playerProfile;
        }

        public static CheckServerReport ofUser(User user, PlayerProfile playerProfile) {
            return new CheckServerReport(user.getUUID(), user, playerProfile);
        }

        public static CheckServerReport ofUUID(UUID uuid, PlayerProfile playerProfile) {
            return new CheckServerReport(uuid, null, playerProfile);
        }
    }
}

