/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.CheckServerRequestEvent;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.HookException;

public class CheckServerResponse
extends SimpleResponse {
    private final transient Logger logger = LogManager.getLogger();
    public String serverID;
    public String username;
    public String client;

    @Override
    public String getType() {
        return "checkServer";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client pClient) {
        if (!pClient.isAuth || pClient.type == AuthResponse.ConnectTypes.CLIENT) {
            this.sendError("Permissions denied");
            return;
        }
        CheckServerRequestEvent result = new CheckServerRequestEvent();
        try {
            this.server.authHookManager.checkServerHook.hook((Object)this, (Object)pClient);
            AuthManager.CheckServerReport report = this.server.authManager.checkServer(pClient, this.username, this.serverID);
            if (report != null) {
                result.playerProfile = report.playerProfile;
                result.uuid = report.uuid;
                this.logger.debug("checkServer: {} uuid: {} serverID: {}", (Object)(result.playerProfile == null ? null : result.playerProfile.username), (Object)result.uuid, (Object)this.serverID);
            }
        }
        catch (AuthException | HookException e) {
            this.sendError(e.getMessage());
            return;
        }
        catch (Exception e) {
            this.logger.error("Internal authHandler error", (Throwable)e);
            this.sendError("Internal authHandler error");
            return;
        }
        this.sendResult((RequestEvent)result);
    }
}

