/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.protect.hwid;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.MySQLSourceConfig;
import pro.gravit.launchserver.auth.protect.hwid.HWIDException;
import pro.gravit.launchserver.auth.protect.hwid.HWIDProvider;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.utils.helper.IOHelper;

public class MysqlHWIDProvider
extends HWIDProvider {
    private final transient Logger logger = LogManager.getLogger();
    public MySQLSourceConfig mySQLHolder;
    public double warningSpoofingLevel = -1.0;
    public double criticalCompareLevel = 1.0;
    public String tableHWID = "hwids";
    public String tableHWIDLog = "hwidLog";
    public String tableUsers;
    public String usersNameColumn;
    public String usersHWIDColumn;
    private String sqlFindByPublicKey;
    private String sqlFindByHardware;
    private String sqlCreateHardware;
    private String sqlCreateHWIDLog;
    private String sqlUpdateHardware;
    private String sqlUpdateUsers;

    @Override
    public void init(LaunchServer server) {
        this.sqlFindByPublicKey = String.format("SELECT hwDiskId, baseboardSerialNumber, displayId, bitness, totalMemory, logicalProcessors, physicalProcessors, processorMaxFreq, battery, id, banned FROM %s WHERE `publicKey` = ?", this.tableHWID);
        this.sqlFindByHardware = String.format("SELECT hwDiskId, baseboardSerialNumber, displayId, bitness, totalMemory, logicalProcessors, physicalProcessors, processorMaxFreq, battery, id, banned FROM %s", this.tableHWID);
        this.sqlCreateHardware = String.format("INSERT INTO `%s` (`publickey`, `hwDiskId`, `baseboardSerialNumber`, `displayId`, `bitness`, `totalMemory`, `logicalProcessors`, `physicalProcessors`, `processorMaxFreq`, `battery`, `banned`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '0')", this.tableHWID);
        this.sqlCreateHWIDLog = String.format("INSERT INTO %s (`hwidId`, `newPublicKey`) VALUES (?, ?)", this.tableHWIDLog);
        this.sqlUpdateHardware = String.format("UPDATE %s SET `publicKey` = ? WHERE `id` = ?", this.tableHWID);
        if (this.tableUsers != null && this.usersHWIDColumn != null && this.usersNameColumn != null) {
            this.sqlUpdateUsers = String.format("UPDATE %s SET `%s` = ? WHERE `%s` = ?", this.tableUsers, this.usersHWIDColumn, this.usersNameColumn);
        } else {
            this.logger.warn("[MysqlHWIDProvider] Link to users table not configured");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HardwareReportRequest.HardwareInfo findHardwareInfoByPublicKey(byte[] publicKey, Client client) throws HWIDException {
        try (Connection connection = this.mySQLHolder.getConnection();){
            PreparedStatement s = connection.prepareStatement(this.sqlFindByPublicKey);
            s.setBlob(1, new ByteArrayInputStream(publicKey));
            ResultSet set = s.executeQuery();
            if (set.next()) {
                if (set.getBoolean(11)) {
                    throw new HWIDException("You HWID banned");
                }
                long id = set.getLong(10);
                this.setUserHardwareId(connection, client.username, id);
                HardwareReportRequest.HardwareInfo hardwareInfo2 = this.fetchHardwareInfo(set);
                return hardwareInfo2;
            }
            HardwareReportRequest.HardwareInfo hardwareInfo = null;
            return hardwareInfo;
        }
        catch (IOException | SQLException throwables) {
            this.logger.error((Object)throwables);
            throw new HWIDException("SQL error. Please try again later");
        }
    }

    private HardwareReportRequest.HardwareInfo fetchHardwareInfo(ResultSet set) throws SQLException, IOException {
        HardwareReportRequest.HardwareInfo hardwareInfo = new HardwareReportRequest.HardwareInfo();
        hardwareInfo.hwDiskId = set.getString(1);
        hardwareInfo.baseboardSerialNumber = set.getString(2);
        Blob displayId = set.getBlob(3);
        hardwareInfo.displayId = displayId == null ? null : IOHelper.read((InputStream)displayId.getBinaryStream());
        hardwareInfo.bitness = set.getInt(4);
        hardwareInfo.totalMemory = set.getLong(5);
        hardwareInfo.logicalProcessors = set.getInt(6);
        hardwareInfo.physicalProcessors = set.getInt(7);
        hardwareInfo.processorMaxFreq = set.getLong(8);
        hardwareInfo.battery = set.getBoolean(9);
        return hardwareInfo;
    }

    @Override
    public void createHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, Client client) throws HWIDException {
        try (Connection connection = this.mySQLHolder.getConnection();){
            PreparedStatement s = connection.prepareStatement(this.sqlCreateHardware, 1);
            s.setBlob(1, new ByteArrayInputStream(publicKey));
            s.setString(2, hardwareInfo.hwDiskId);
            s.setString(3, hardwareInfo.baseboardSerialNumber);
            s.setBlob(4, hardwareInfo.displayId == null ? null : new ByteArrayInputStream(hardwareInfo.displayId));
            s.setInt(5, hardwareInfo.bitness);
            s.setLong(6, hardwareInfo.totalMemory);
            s.setInt(7, hardwareInfo.logicalProcessors);
            s.setInt(8, hardwareInfo.physicalProcessors);
            s.setLong(9, hardwareInfo.processorMaxFreq);
            s.setBoolean(10, hardwareInfo.battery);
            s.executeUpdate();
            try (ResultSet generatedKeys = s.getGeneratedKeys();){
                if (generatedKeys.next()) {
                    this.writeHwidLog(connection, generatedKeys.getLong(1), publicKey);
                    this.setUserHardwareId(connection, client.username, generatedKeys.getLong(1));
                }
            }
        }
        catch (SQLException throwables) {
            this.logger.error((Object)throwables);
            throw new HWIDException("SQL error. Please try again later");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addPublicKeyToHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, Client client) throws HWIDException {
        try (Connection connection = this.mySQLHolder.getConnection();){
            long id;
            HWIDProvider.HardwareInfoCompareResult result;
            PreparedStatement s = connection.prepareStatement(this.sqlFindByHardware);
            ResultSet set = s.executeQuery();
            do {
                if (!set.next()) return false;
                HardwareReportRequest.HardwareInfo hw = this.fetchHardwareInfo(set);
                id = set.getLong(10);
                result = this.compareHardwareInfo(hw, hardwareInfo);
            } while (!(result.compareLevel > this.criticalCompareLevel));
            if (set.getBoolean(11)) {
                throw new HWIDException("You HWID banned");
            }
            this.writeHwidLog(connection, id, publicKey);
            this.changePublicKey(connection, id, publicKey);
            this.setUserHardwareId(connection, client.username, id);
            boolean bl = true;
            return bl;
        }
        catch (IOException | SQLException throwables) {
            this.logger.error((Object)throwables);
            throw new HWIDException("SQL error. Please try again later");
        }
    }

    private void changePublicKey(Connection connection, long id, byte[] publicKey) throws SQLException {
        PreparedStatement s = connection.prepareStatement(this.sqlUpdateHardware);
        s.setBlob(1, new ByteArrayInputStream(publicKey));
        s.setLong(2, id);
        s.executeUpdate();
    }

    private void writeHwidLog(Connection connection, long hwidId, byte[] newPublicKey) throws SQLException {
        PreparedStatement s = connection.prepareStatement(this.sqlCreateHWIDLog);
        s.setLong(1, hwidId);
        s.setBlob(2, new ByteArrayInputStream(newPublicKey));
        s.executeUpdate();
    }

    private void setUserHardwareId(Connection connection, String username, long hwidId) throws SQLException {
        if (this.sqlUpdateUsers == null || username == null) {
            return;
        }
        PreparedStatement s = connection.prepareStatement(this.sqlUpdateUsers);
        s.setLong(1, hwidId);
        s.setString(2, username);
        s.executeUpdate();
    }

    @Override
    public void close() {
        this.mySQLHolder.close();
    }
}

