/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.components;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.launchserver.components.Component;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.UnpackHelper;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ParseException;
import proguard.ProGuard;

public class ProGuardComponent
extends Component
implements AutoCloseable,
Reconfigurable {
    private static final transient Logger logger = LogManager.getLogger();
    public String modeAfter = "MainBuild";
    public String dir = "proguard";
    public boolean enabled = true;
    public boolean mappings = true;
    public transient ProguardConf proguardConf;
    private transient LaunchServer launchServer;
    private transient ProGuardBuildTask buildTask;

    public static boolean checkFXJMods(Path path) {
        if (!IOHelper.exists((Path)path.resolve("javafx.base.jmod"))) {
            return false;
        }
        if (!IOHelper.exists((Path)path.resolve("javafx.graphics.jmod"))) {
            return false;
        }
        return IOHelper.exists((Path)path.resolve("javafx.controls.jmod"));
    }

    public static boolean checkJMods(Path path) {
        return IOHelper.exists((Path)path.resolve("java.base.jmod"));
    }

    public static Path tryFindOpenJFXPath(Path jvmDir) {
        Path debianJfxPath;
        String dirName = jvmDir.getFileName().toString();
        Path parent = jvmDir.getParent();
        if (parent == null) {
            return null;
        }
        Path archJFXPath = parent.resolve(dirName.replace("openjdk", "openjfx")).resolve("jmods");
        if (Files.isDirectory(archJFXPath, new LinkOption[0])) {
            return archJFXPath;
        }
        Path arch2JFXPath = parent.resolve(dirName.replace("jdk", "openjfx")).resolve("jmods");
        if (Files.isDirectory(arch2JFXPath, new LinkOption[0])) {
            return arch2JFXPath;
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX && Files.isDirectory(debianJfxPath = Paths.get("/usr/share/openjfx/jmods", new String[0]), new LinkOption[0])) {
            return debianJfxPath;
        }
        return null;
    }

    @Override
    public void init(LaunchServer launchServer) {
        this.launchServer = launchServer;
        this.proguardConf = new ProguardConf(launchServer, this);
        this.buildTask = new ProGuardBuildTask(launchServer, this.proguardConf, this);
        launchServer.launcherBinary.addAfter(v -> v.getName().startsWith(this.modeAfter), this.buildTask);
    }

    @Override
    public void close() throws Exception {
        if (this.launchServer != null && this.buildTask != null) {
            this.launchServer.launcherBinary.tasks.remove(this.buildTask);
        }
    }

    @Override
    public Map<String, Command> getCommands() {
        Map<String, Command> commands = this.defaultCommandsMap();
        commands.put("reset", (Command)new SubCommand("[]", "reset proguard config"){

            public void invoke(String ... args) throws Exception {
                ProGuardComponent.this.proguardConf.prepare(true);
                Files.deleteIfExists(ProGuardComponent.this.proguardConf.mappings);
            }
        });
        commands.put("regen", (Command)new SubCommand("[]", "regenerate proguard dictionary"){

            public void invoke(String ... args) throws Exception {
                ProGuardComponent.this.proguardConf.genWords(true);
            }
        });
        commands.put("clean", (Command)new SubCommand("[]", "clean proguard mappings"){

            public void invoke(String ... args) throws Exception {
                ProGuardComponent.this.proguardConf.prepare(true);
                Files.deleteIfExists(ProGuardComponent.this.proguardConf.mappings);
            }
        });
        return null;
    }

    public static class ProguardConf {
        public static final String[] JAVA9_OPTS = new String[]{"-libraryjars '<java.home>/jmods/'"};
        public static final String[] JAVA8_OPTS = new String[]{"-libraryjars '<java.home>/lib/rt.jar'", "-libraryjars '<java.home>/lib/jce.jar'", "-libraryjars '<java.home>/lib/ext/nashorn.jar'", "-libraryjars '<java.home>/lib/ext/jfxrt.jar'"};
        private static final char[] chars = "1aAbBcC2dDeEfF3gGhHiI4jJkKl5mMnNoO6pPqQrR7sStT8uUvV9wWxX0yYzZ".toCharArray();
        public final Path proguard;
        public final Path config;
        public final Path mappings;
        public final Path words;
        public final transient LaunchServer srv;
        private final transient ProGuardComponent component;

        public ProguardConf(LaunchServer srv, ProGuardComponent component) {
            this.component = component;
            this.proguard = srv.dir.resolve(component.dir);
            this.config = this.proguard.resolve("proguard.config");
            this.mappings = this.proguard.resolve("mappings.pro");
            this.words = this.proguard.resolve("random.pro");
            this.srv = srv;
        }

        private static String generateString(SecureRandom rand, String lowString, String upString, int il) {
            StringBuilder sb = new StringBuilder(Math.max(il, lowString.length()));
            for (int i = 0; i < lowString.length(); ++i) {
                sb.append(rand.nextBoolean() ? lowString.charAt(i) : upString.charAt(i));
            }
            int toI = il - lowString.length();
            for (int i = 0; i < toI; ++i) {
                sb.append(chars[rand.nextInt(chars.length)]);
            }
            return sb.toString();
        }

        public String[] buildConfig(Path inputJar, Path outputJar, Path[] jfxPath) {
            ArrayList<Object> confStrs = new ArrayList<Object>();
            this.prepare(false);
            if (this.component.mappings) {
                confStrs.add("-printmapping '" + this.mappings.toFile().getName() + "'");
            }
            confStrs.add("-obfuscationdictionary '" + this.words.toFile().getName() + "'");
            confStrs.add("-injar '" + inputJar.toAbsolutePath() + "'");
            confStrs.add("-outjar '" + outputJar.toAbsolutePath() + "'");
            Collections.addAll(confStrs, JAVA9_OPTS);
            if (jfxPath != null) {
                for (Path path : jfxPath) {
                    confStrs.add(String.format("-libraryjars '%s'", path.toAbsolutePath()));
                }
            }
            this.srv.launcherBinary.coreLibs.stream().map(e -> "-libraryjars '" + e.toAbsolutePath() + "'").forEach(confStrs::add);
            this.srv.launcherBinary.addonLibs.stream().map(e -> "-libraryjars '" + e.toAbsolutePath() + "'").forEach(confStrs::add);
            confStrs.add("-classobfuscationdictionary '" + this.words.toFile().getName() + "'");
            confStrs.add("@".concat(this.config.toFile().getName()));
            return confStrs.toArray(new String[0]);
        }

        private void genConfig(boolean force) throws IOException {
            if (IOHelper.exists((Path)this.config) && !force) {
                return;
            }
            Files.deleteIfExists(this.config);
            UnpackHelper.unpack((URL)IOHelper.getResourceURL((String)"pro/gravit/launchserver/defaults/proguard.cfg"), (Path)this.config);
        }

        public void genWords(boolean force) throws IOException {
            if (IOHelper.exists((Path)this.words) && !force) {
                return;
            }
            Files.deleteIfExists(this.words);
            SecureRandom rand = SecurityHelper.newRandom();
            rand.setSeed(SecureRandom.getSeed(32));
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter(IOHelper.newOutput((Path)this.words), IOHelper.UNICODE_CHARSET));){
                String projectName = this.srv.config.projectName.replaceAll("\\W", "");
                String lowName = projectName.toLowerCase();
                String upName = projectName.toUpperCase();
                for (int i = 0; i < Short.MAX_VALUE; ++i) {
                    out.println(ProguardConf.generateString(rand, lowName, upName, 14));
                }
            }
        }

        public void prepare(boolean force) {
            try {
                IOHelper.createParentDirs((Path)this.config);
                this.genWords(force);
                this.genConfig(force);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public static class ProGuardBuildTask
    implements LauncherBuildTask {
        private final LaunchServer server;
        private final ProGuardComponent component;
        private final ProguardConf proguardConf;

        public ProGuardBuildTask(LaunchServer server, ProguardConf conf, ProGuardComponent component) {
            this.server = server;
            this.component = component;
            this.proguardConf = conf;
        }

        @Override
        public String getName() {
            return "ProGuard.".concat(this.component.componentName);
        }

        @Override
        public Path process(Path inputFile) throws IOException {
            Path outputJar = this.server.launcherBinary.nextLowerPath(this);
            if (this.component.enabled) {
                Path[] pathArray;
                Configuration proguard_cfg = new Configuration();
                if (!ProGuardComponent.checkJMods(IOHelper.JVM_DIR.resolve("jmods"))) {
                    logger.error("Java path: {} is not JDK! Please install JDK", (Object)IOHelper.JVM_DIR);
                }
                Path jfxPath = ProGuardComponent.tryFindOpenJFXPath(IOHelper.JVM_DIR);
                if (ProGuardComponent.checkFXJMods(IOHelper.JVM_DIR.resolve("jmods"))) {
                    logger.debug("JavaFX jmods resolved in JDK path");
                    jfxPath = null;
                } else if (jfxPath != null && ProGuardComponent.checkFXJMods(jfxPath)) {
                    logger.debug("JMods resolved in {}", (Object)jfxPath.toString());
                } else {
                    logger.error("JavaFX jmods not found. May be install OpenJFX?");
                }
                if (jfxPath == null) {
                    pathArray = new Path[]{};
                } else {
                    Path[] pathArray2 = new Path[1];
                    pathArray = pathArray2;
                    pathArray2[0] = jfxPath;
                }
                ConfigurationParser parser = new ConfigurationParser(this.proguardConf.buildConfig(inputFile, outputJar, pathArray), this.proguardConf.proguard.toFile(), System.getProperties());
                try {
                    parser.parse(proguard_cfg);
                    ProGuard proGuard = new ProGuard(proguard_cfg);
                    proGuard.execute();
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                }
            } else {
                IOHelper.copy((Path)inputFile, (Path)outputJar);
            }
            return outputJar;
        }

        @Override
        public boolean allowDelete() {
            return true;
        }
    }
}

